/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator;

import java.util.List;
import org.instancio.generator.AfterGenerate;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.GeneratorSpec;
import org.instancio.generator.Hints;
import org.instancio.generators.Generators;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.GeneratorResolver;
import org.instancio.internal.generator.InternalGeneratorHint;
import org.instancio.internal.generator.array.ArrayGenerator;
import org.instancio.internal.generator.misc.GeneratorDecorator;
import org.instancio.internal.generators.BuiltInGenerators;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.spi.ProviderEntry;
import org.instancio.internal.util.ObjectUtils;
import org.instancio.settings.Keys;
import org.instancio.spi.InstancioServiceProvider;
import org.instancio.spi.InstancioSpiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpiGeneratorResolver {
    private static final Logger LOG = LoggerFactory.getLogger(SpiGeneratorResolver.class);
    private final GeneratorContext generatorContext;
    private final Generators generators;
    private final GeneratorResolver generatorResolver;
    private final List<ProviderEntry<InstancioServiceProvider.GeneratorProvider>> providerEntries;
    private final AfterGenerate afterGenerate;

    public SpiGeneratorResolver(ModelContext modelContext, GeneratorContext generatorContext, GeneratorResolver generatorResolver) {
        this.generatorContext = generatorContext;
        this.generators = new BuiltInGenerators(generatorContext);
        this.generatorResolver = generatorResolver;
        this.providerEntries = modelContext.getServiceProviders().getGeneratorProviders();
        this.afterGenerate = modelContext.getSettings().get(Keys.AFTER_GENERATE_HINT);
    }

    public Generator<?> getSpiGenerator(InternalNode node) {
        for (ProviderEntry<InstancioServiceProvider.GeneratorProvider> entry : this.providerEntries) {
            GeneratorSpec<?> spec = entry.getProvider().getGenerator(node, this.generators);
            if (spec == null) continue;
            SpiGeneratorResolver.validateSpec(entry, spec);
            LOG.trace("Custom generator '{}' found for {}", (Object)spec.getClass().getName(), (Object)node);
            Generator<?> generator = this.processGenerator((Generator)spec, node);
            generator.init(this.generatorContext);
            return GeneratorDecorator.decorateIfNullAfterGenerate(generator, this.afterGenerate);
        }
        return null;
    }

    private Generator<?> processGenerator(Generator<?> generator, InternalNode node) {
        if (generator instanceof ArrayGenerator) {
            ((ArrayGenerator)generator).subtype((Class)node.getTargetClass());
        } else if (generator instanceof AbstractGenerator) {
            AbstractGenerator g = (AbstractGenerator)generator;
            if (!g.isDelegating()) {
                return g;
            }
            Hints hints = generator.hints();
            InternalGeneratorHint internalHint = hints.get(InternalGeneratorHint.class);
            Generator<?> delegate = this.generatorResolver.getCachedBuiltInGenerator(ObjectUtils.defaultIfNull(internalHint.targetClass(), node.getTargetClass()));
            if (delegate == null) {
                return generator;
            }
            if (delegate instanceof AbstractGenerator) {
                boolean nullable = ((AbstractGenerator)generator).isNullable();
                ((AbstractGenerator)delegate).nullable(nullable);
            }
            return GeneratorDecorator.replaceHints(delegate, hints);
        }
        return generator;
    }

    private static void validateSpec(ProviderEntry<InstancioServiceProvider.GeneratorProvider> entry, GeneratorSpec<?> spec) {
        if (spec instanceof Generator) {
            return;
        }
        throw new InstancioSpiException(String.format("The GeneratorSpec %s returned by %s must implement %s", spec.getClass(), entry.getInstancioProviderClass(), Generator.class));
    }
}

