/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.feed;

import java.io.InputStream;
import java.nio.file.Path;
import org.instancio.documentation.ExperimentalApi;
import org.instancio.feed.DataSource;
import org.instancio.internal.feed.datasource.FileDataSource;
import org.instancio.internal.feed.datasource.ResourceDataSource;
import org.instancio.internal.feed.datasource.StringDataSource;

@ExperimentalApi
@FunctionalInterface
public interface DataSourceProvider {
    @ExperimentalApi
    public DataSource get(DataSourceFactory var1);

    @ExperimentalApi
    public static interface DataSourceFactory {
        @ExperimentalApi
        default public DataSource ofInputStream(InputStream inputStream) {
            return () -> inputStream;
        }

        @ExperimentalApi
        default public DataSource ofFile(Path path) {
            return new FileDataSource(path);
        }

        @ExperimentalApi
        default public DataSource ofResource(String name) {
            return new ResourceDataSource(name);
        }

        @ExperimentalApi
        default public DataSource ofString(String data) {
            return new StringDataSource(data);
        }
    }
}

