/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Locale;
import java.util.stream.Collectors;
import org.instancio.feed.DataSource;
import org.instancio.feed.Feed;
import org.instancio.generator.Generator;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.feed.SpecMethod;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.Constants;
import org.instancio.internal.util.Format;
import org.instancio.internal.util.StringUtils;
import org.instancio.settings.AssignmentType;
import org.instancio.settings.FeedDataAccess;
import org.instancio.settings.FeedDataEndAction;
import org.instancio.settings.Keys;
import org.instancio.settings.OnFeedPropertyUnmatched;
import org.instancio.settings.OnSetFieldError;
import org.instancio.settings.OnSetMethodError;
import org.instancio.settings.OnSetMethodNotFound;
import org.instancio.settings.SetterStyle;
import org.instancio.settings.SettingKey;
import org.instancio.settings.Settings;

public final class ErrorMessageUtils {
    private static final int INITIAL_SB_SIZE = 1024;

    private ErrorMessageUtils() {
    }

    public static String maxGenerationAttemptsExceeded(InternalNode node, int maxGenerationAttempts) {
        return new StringBuilder(1024).append("failed generating a value for node:").append(Constants.NL).append(Constants.NL).append(Format.nodePathToRootBlock(node)).append(Constants.NL).append(Constants.NL).append(" -> Generation was abandoned after ").append(maxGenerationAttempts).append(" attempts to avoid an infinite loop").append(Constants.NL).append("    (configured using the ").append(ErrorMessageUtils.keyDesc(Keys.MAX_GENERATION_ATTEMPTS)).append(" settings)").append(Constants.NL).append(Constants.NL).append("Possible causes:").append(Constants.NL).append(Constants.NL).append(" -> filter() predicate rejected too many generated values, exceeding the maximum number of attempts").append(Constants.NL).append(" -> withUnique() method unable to generate a sufficient number of unique values").append(Constants.NL).append(" -> a hash-based collection (a Set or Map) of a given size could not be populated").append(Constants.NL).append(Constants.NL).append("To resolve this error:").append(Constants.NL).append(Constants.NL).append(" -> update the generation parameters to address the root cause").append(Constants.NL).append(" -> increase the value of the ").append(ErrorMessageUtils.keyDesc(Keys.MAX_GENERATION_ATTEMPTS)).append(" setting").toString();
    }

    public static String filterPredicateErrorMessage(Object value, InternalNode node, Throwable ex) {
        String argValue = StringUtils.quoteStringValue(value);
        return new StringBuilder(1024).append("filter() predicate threw an exception").append(Constants.NL).append(" -> Value provided to predicate: ").append(argValue).append(Constants.NL).append(" -> Target node: ").append(Format.nodePathToRootBlock(node)).append(Constants.NL).append(Constants.NL).append("Root cause:").append(Constants.NL).append(" -> ").append(ErrorMessageUtils.getRootCause(ex)).toString();
    }

    public static String unableToGetValueFromField(Field field, Object target) {
        return new StringBuilder(300).append("unable to get value from field.").append(Constants.NL).append(Constants.NL).append(" -> Field........: ").append(field).append(Constants.NL).append(" -> Target type..: ").append(target.getClass()).append(Constants.NL).append(Constants.NL).append("If you think this is a bug, please submit a bug report including the stacktrace:").append(Constants.NL).append("https://github.com/instancio/instancio/issues").toString();
    }

    public static String unableToResolveFieldFromMethodRef(Class<?> targetClass, String lambdaImplMethodName) {
        String at = Format.firstNonInstancioStackTraceLine(new Throwable());
        return new StringBuilder(1024).append(Constants.NL).append(Constants.NL).append("Unable to resolve the field from method reference:").append(Constants.NL).append("-> ").append(Format.withoutPackage(targetClass)).append("::").append(lambdaImplMethodName).append(Constants.NL).append("   at ").append(at).append(Constants.NL).append(Constants.NL).append("Potential causes:").append(Constants.NL).append("-> The method and the corresponding field do not follow expected naming conventions").append(Constants.NL).append("   See: https://www.instancio.org/user-guide/#method-reference-selector").append(Constants.NL).append("-> The method is abstract, declared in a superclass, and the field is declared in a subclass").append(Constants.NL).append("-> The method reference is expressed as a lambda function").append(Constants.NL).append("   Example:     field((SamplePojo pojo) -> pojo.getValue())").append(Constants.NL).append("   Instead of:  field(SamplePojo::getValue)").append(Constants.NL).append("-> You are using Kotlin and passing a method reference of a Kotlin class").append(Constants.NL).append(Constants.NL).append("Possible solutions:").append(Constants.NL).append("-> Resolve the above issues, if applicable").append(Constants.NL).append("-> Specify the field name explicitly, e.g.").append(Constants.NL).append("   field(Example.class, \"someField\")").append(Constants.NL).append("-> If using Kotlin, consider creating a 'KSelect' utility class, for example:").append(Constants.NL).append(Constants.NL).append("   class KSelect {").append(Constants.NL).append("       companion object {").append(Constants.NL).append("           fun <T, V> field(property: KProperty1<T, V>): TargetSelector {").append(Constants.NL).append("               val field = property.javaField!!").append(Constants.NL).append("               return Select.field(field.declaringClass, field.name)").append(Constants.NL).append("           }").append(Constants.NL).append("       }").append(Constants.NL).append("   }").append(Constants.NL).append(Constants.NL).append("   Usage: KSelect.field(SamplePojo::value)").append(Constants.NL).toString();
    }

    public static String createSetterSelectorWithFieldAssignmentErrorMessage(String selectorLocation) {
        return new StringBuilder(512).append("setter() selector cannot be used with AssignmentType.FIELD:").append(Constants.NL).append(" -> ").append(selectorLocation).append(Constants.NL).append(Constants.NL).append("Root cause:").append(Constants.NL).append(Constants.NL).append("Instancio provides the 'Keys.ASSIGNMENT_TYPE' setting that").append(Constants.NL).append("determines how objects are populated. The setting supports two options:").append(Constants.NL).append(Constants.NL).append(" -> AssignmentType.FIELD (default behaviour)").append(Constants.NL).append("    Objects are populated via fields only. Setter methods are ignored.").append(Constants.NL).append("    This is the recommended setting for most uses cases.").append(Constants.NL).append(Constants.NL).append(" -> AssignmentType.METHOD").append(Constants.NL).append("    Objects are populated via methods and (optionally) fields.").append(Constants.NL).append(Constants.NL).append("Using setter() selectors is only supported with METHOD assignment.").append(Constants.NL).append(Constants.NL).append("    // Example").append(Constants.NL).append("    Settings settings = Settings.create()").append(Constants.NL).append("        .set(Keys.ASSIGNMENT_TYPE, AssignmentType.METHOD);").append(Constants.NL).append(Constants.NL).append("    Pojo pojo = Instancio.of(Pojo.class)").append(Constants.NL).append("        .withSettings(settings)").append(Constants.NL).append("        .set(setter(Pojo::setValue), \"foo\")").append(Constants.NL).append("        .create();").append(Constants.NL).append(Constants.NL).append("See https://www.instancio.org/user-guide/#assignment-settings for details").toString();
    }

    public static String getTypeMismatchErrorMessage(Object value, InternalNode node) {
        return ErrorMessageUtils.getTypeMismatchErrorMessage(value, node, null);
    }

    public static String getTypeMismatchErrorMessage(Object value, InternalNode node, Throwable cause) {
        StringBuilder sb = new StringBuilder(1024).append("error assigning value to: ").append(Format.nodePathToRootBlock(node)).append(Constants.NL).append(Constants.NL).append(Constants.NL);
        ErrorMessageUtils.appendTypeMismatchDetails(value, node, sb);
        if (cause != null) {
            sb.append(Constants.NL).append(Constants.NL).append("Root cause:").append(Constants.NL).append(" -> ").append(ErrorMessageUtils.getRootCause(cause));
        }
        return sb.toString();
    }

    public static String fillParameterizedType(Class<?> type) {
        return new StringBuilder(1024).append("cannot fill() parameterized types").append(Constants.NL).append(Constants.NL).append("The following methods do not support populating parameterized types, except List<E> and Map<K, V>:").append(Constants.NL).append(Constants.NL).append(" -> Instancio.fill(Object)").append(Constants.NL).append(" -> Instancio.ofObject(Object).fill()").append(Constants.NL).append(Constants.NL).append("The provided argument is of type:").append(Constants.NL).append(Constants.NL).append(" -> ").append(Format.simpleNameWithTypeParameters(type)).toString();
    }

    public static String getContainerElementMismatchMessage(String errorMsg, Object value, InternalNode containerNode, InternalNode elementNode) {
        StringBuilder sb = new StringBuilder(1024).append(errorMsg).append(": ").append(Format.nodePathToRootBlock(containerNode)).append(Constants.NL).append(Constants.NL).append(Constants.NL);
        ErrorMessageUtils.appendTypeMismatchDetails(value, elementNode, sb);
        return sb.toString();
    }

    public static String abstractRootWithoutSubtype(Class<?> klass) {
        StringBuilder sb = new StringBuilder(1024).append("could not create an instance of ").append(klass).append(Constants.NL).append(Constants.NL).append("Cause:").append(Constants.NL).append(Constants.NL);
        if (Feed.class.isAssignableFrom(klass)) {
            return sb.append(" -> The specified class is an instance of ").append(Feed.class.getName()).append(Constants.NL).append(Constants.NL).append("To resolve this error:").append(Constants.NL).append(Constants.NL).append(" -> Use the createFeed(Class) method:").append(Constants.NL).append(Constants.NL).append("    ExampleFeed feed = Instancio.createFeed(ExampleFeed.class);").append(Constants.NL).append(Constants.NL).append(" -> Or the builder API:").append(Constants.NL).append(Constants.NL).append("    ExampleFeed feed = Instancio.of(ExampleFeed.class)").append(Constants.NL).append("        // snip ...").append(Constants.NL).append("        .create();").append(Constants.NL).toString();
        }
        return sb.append(" -> It is an abstract class and no subtype was provided").append(Constants.NL).append(Constants.NL).append("To resolve this error:").append(Constants.NL).append(Constants.NL).append(" -> Specify the subtype using the builder API:").append(Constants.NL).append(Constants.NL).append("    AbstractPojo pojo = Instancio.of(AbstractPojo.class)").append(Constants.NL).append("        .subtype(all(AbstractPojo.class), ConcretePojo.class)").append(Constants.NL).append("        .create();").append(Constants.NL).append(Constants.NL).append(" -> Or alternatively, specify the subtype using Settings:").append(Constants.NL).append(Constants.NL).append("    Settings settings = Settings.create()").append(Constants.NL).append("        .mapType(AbstractPojo.class, ConcretePojo.class);").append(Constants.NL).append(Constants.NL).append("    AbstractPojo pojo = Instancio.of(AbstractPojo.class)").append(Constants.NL).append("        .withSettings(settings)").append(Constants.NL).append("        .create();").append(Constants.NL).append(Constants.NL).append("For more information see: https://www.instancio.org/user-guide/#subtype-mapping").toString();
    }

    public static String collectionCouldNotBePopulated(ModelContext context, InternalNode node, int targetSize) {
        Settings settings = context.getSettings();
        return new StringBuilder(1024).append("unable to populate Collection of size ").append(targetSize).append(": ").append(Format.nodePathToRootBlock(node)).append(Constants.NL).append(Constants.NL).append(Constants.NL).append("Could not generate enough elements to populate the collection.").append(Constants.NL).append("This typically occurs with Sets when the number of potential values is").append(Constants.NL).append("limited and the target set cannot be generated due to duplicate element").append(Constants.NL).append("values, for example:").append(Constants.NL).append(Constants.NL).append(" -> The element type is an enum").append(Constants.NL).append(Constants.NL).append(" -> The element type is a POJO, but blank POJOs are being generated").append(Constants.NL).append("    because the configured maximum depth has been reached").append(Constants.NL).append(Constants.NL).append(" -> The element is an abstract type and no subtype was specified.").append(Constants.NL).append("    See https://www.instancio.org/user-guide/#subtype-mapping for details").append(Constants.NL).append(Constants.NL).append("Model properties:").append(Constants.NL).append(Constants.NL).append(" -> Collection target size: ").append(targetSize).append(Constants.NL).append(Constants.NL).append("    The size was either chosen randomly based on current settings,").append(Constants.NL).append("    or may have been specified explicitly via the API.").append(Constants.NL).append(Constants.NL).append(" -> Current size settings are").append(Constants.NL).append(Constants.NL).append("    Keys.COLLECTION_MIN_SIZE: ").append(settings.get(Keys.COLLECTION_MIN_SIZE)).append(Constants.NL).append("    Keys.COLLECTION_MAX_SIZE: ").append(settings.get(Keys.COLLECTION_MAX_SIZE)).append(Constants.NL).append(Constants.NL).append(" -> Keys.MAX_DEPTH: ").append(settings.get(Keys.MAX_DEPTH)).append(Constants.NL).append(Constants.NL).append(" -> Model max depth: ").append(context.getMaxDepth()).append(Constants.NL).append(Constants.NL).append("    Unless overridden using withMaxDepth() method,").append(Constants.NL).append("    this value should be the same as Keys.MAX_DEPTH").append(Constants.NL).append(Constants.NL).append("For more information see: https://www.instancio.org/user-guide/#error-handling").toString();
    }

    public static String mapCouldNotBePopulated(ModelContext context, InternalNode node, int targetSize) {
        Settings settings = context.getSettings();
        return new StringBuilder(1024).append("unable to populate Map of size ").append(targetSize).append(": ").append(Format.nodePathToRootBlock(node)).append(Constants.NL).append(Constants.NL).append(Constants.NL).append("Could not generate enough entries to populate the map.").append(Constants.NL).append("This occurs when the number of potential map keys is limited").append(Constants.NL).append("and the target map cannot be generated due to duplicate keys,").append(Constants.NL).append("for example:").append(Constants.NL).append(Constants.NL).append(" -> The key type is an enum").append(Constants.NL).append(Constants.NL).append(" -> The key type is a POJO, but blank POJOs are being generated").append(Constants.NL).append("    because the configured maximum depth has been reached").append(Constants.NL).append(Constants.NL).append(" -> The key or value is an abstract type and no subtype was specified.").append(Constants.NL).append("    See https://www.instancio.org/user-guide/#subtype-mapping for details").append(Constants.NL).append(Constants.NL).append("Model properties:").append(Constants.NL).append(Constants.NL).append(" -> Map target size: ").append(targetSize).append(Constants.NL).append(Constants.NL).append("    The size was either chosen randomly based on current settings,").append(Constants.NL).append("    or may have been specified explicitly via the API.").append(Constants.NL).append(Constants.NL).append(" -> Current size settings are").append(Constants.NL).append(Constants.NL).append("    Keys.MAP_MIN_SIZE: ").append(settings.get(Keys.MAP_MIN_SIZE)).append(Constants.NL).append("    Keys.MAP_MAX_SIZE: ").append(settings.get(Keys.MAP_MAX_SIZE)).append(Constants.NL).append(Constants.NL).append(" -> Keys.MAX_DEPTH: ").append(settings.get(Keys.MAX_DEPTH)).append(Constants.NL).append(Constants.NL).append(" -> Model max depth: ").append(context.getMaxDepth()).append(Constants.NL).append(Constants.NL).append("    Unless overridden using withMaxDepth() method,").append(Constants.NL).append("    this value should be the same as Keys.MAX_DEPTH").append(Constants.NL).append(Constants.NL).append("For more information see: https://www.instancio.org/user-guide/#error-handling").toString();
    }

    private static void appendTypeMismatchDetails(Object value, InternalNode node, StringBuilder sb) {
        String nodeDescription = Format.formatNode(node);
        String argType = Format.withoutPackage(value.getClass());
        String argValue = StringUtils.quoteStringValue(value);
        sb.append("Type mismatch:").append(Constants.NL).append(Constants.NL);
        if (node.getField() == null) {
            sb.append(" -> Target type ..............: ");
        } else {
            sb.append(" -> Target field .............: ");
        }
        sb.append(nodeDescription).append(Constants.NL).append(" -> Provided argument type ...: ").append(argType).append(Constants.NL).append(" -> Provided argument value ..: ").append(argValue);
    }

    public static String incompatibleField(Object value, Field field, Throwable cause, Settings settings) {
        OnSetFieldError onSetFieldError = settings.get(Keys.ON_SET_FIELD_ERROR);
        String fieldName = Format.formatField(field);
        String argType = Format.withoutPackage(value.getClass());
        String argValue = StringUtils.quoteStringValue(value);
        return new StringBuilder(1024).append(Constants.NL).append("Throwing exception because:").append(Constants.NL).append(" -> Keys.ON_SET_FIELD_ERROR = ").append((Object)onSetFieldError).append(Constants.NL).append(Constants.NL).append("Error assigning value to field:").append(Constants.NL).append(Constants.NL).append(" -> Target field: ............: ").append(fieldName).append(Constants.NL).append(" -> Provided argument type ...: ").append(argType).append(Constants.NL).append(" -> Provided argument value ..: ").append(argValue).append(Constants.NL).append(Constants.NL).append("Root cause:").append(Constants.NL).append(" -> ").append(ErrorMessageUtils.getRootCause(cause)).append(Constants.NL).append(Constants.NL).append("To ignore the error and leave the field uninitialised").append(Constants.NL).append(" -> Update Keys.ON_SET_FIELD_ERROR setting to: ").append((Object)OnSetFieldError.IGNORE).append(Constants.NL).toString();
    }

    public static String setterNotFound(InternalNode node, Settings settings) {
        String fieldName = Format.formatField(node.getField());
        SetterStyle setterStyle = settings.get(Keys.SETTER_STYLE);
        OnSetMethodNotFound onSetMethodNotFound = settings.get(Keys.ON_SET_METHOD_NOT_FOUND);
        return new StringBuilder(1024).append(Constants.NL).append("Throwing exception because:").append(Constants.NL).append(" -> Keys.ASSIGNMENT_TYPE = ").append((Object)AssignmentType.METHOD).append(Constants.NL).append(" -> Keys.ON_SET_METHOD_NOT_FOUND = ").append((Object)onSetMethodNotFound).append(Constants.NL).append(Constants.NL).append("Setter method could not be resolved for field:").append(Constants.NL).append(" -> ").append(fieldName).append(Constants.NL).append(Constants.NL).append("Using:").append(Constants.NL).append(" -> Keys.SETTER_STYLE = ").append((Object)setterStyle).append(Constants.NL).append(Constants.NL).append("To resolve the error, consider one of the following:").append(Constants.NL).append(" -> Add the expected setter method").append(Constants.NL).append(" -> Update Keys.ON_SET_METHOD_NOT_FOUND setting to:").append(Constants.NL).append("    -> ").append((Object)OnSetMethodNotFound.ASSIGN_FIELD).append(" to assign value via field").append(Constants.NL).append("    -> ").append((Object)OnSetMethodNotFound.IGNORE).append(" to leave value uninitialised").append(Constants.NL).toString();
    }

    public static String getSetterInvocationErrorMessage(Object value, String method, Throwable cause, Settings settings) {
        OnSetMethodError onSetMethodError = settings.get(Keys.ON_SET_METHOD_ERROR);
        String argType = value == null ? "n/a" : Format.withoutPackage(value.getClass());
        String argValue = StringUtils.quoteStringValue(value);
        return new StringBuilder(1024).append(Constants.NL).append("Throwing exception because:").append(Constants.NL).append(" -> Keys.ASSIGNMENT_TYPE = ").append((Object)AssignmentType.METHOD).append(Constants.NL).append(" -> Keys.ON_SET_METHOD_ERROR = ").append((Object)onSetMethodError).append(Constants.NL).append(Constants.NL).append("Method invocation failed:").append(Constants.NL).append(Constants.NL).append(" -> Method ...................: ").append(method).append(Constants.NL).append(" -> Provided argument type ...: ").append(argType).append(Constants.NL).append(" -> Provided argument value ..: ").append(argValue).append(Constants.NL).append(Constants.NL).append("Root cause:").append(Constants.NL).append(" -> ").append(ErrorMessageUtils.getRootCause(cause)).append(Constants.NL).append(Constants.NL).append("To resolve the error, consider one of the following:").append(Constants.NL).append(" -> Address the root cause that triggered the exception").append(Constants.NL).append(" -> Update Keys.ON_SET_METHOD_ERROR setting to").append(Constants.NL).append("    -> ").append((Object)OnSetMethodError.ASSIGN_FIELD).append(" to assign value via field").append(Constants.NL).append("    -> ").append((Object)OnSetMethodError.IGNORE).append(" to leave value uninitialised").append(Constants.NL).toString();
    }

    public static String selectorNotNullErrorMessage(String message, String methodName, String invokedMethods, Throwable t) {
        String template = "%n  %s%n  method invocation: %s%n  at %s";
        String invocation = String.format("%s.%s( -> null <- )", invokedMethods, methodName);
        String at = Format.firstNonInstancioStackTraceLine(t);
        return String.format("%n  %s%n  method invocation: %s%n  at %s", message, invocation, at);
    }

    public static String invalidAnnotationHandlerMethod(Class<?> annotationProcessorClass, Method method, Annotation annotation, Generator<?> resolvedGenerator, InternalNode node) {
        Class<?>[] paramTypes = method.getParameterTypes();
        Class<?> specifiedGeneratorType = paramTypes.length < 2 ? null : paramTypes[1];
        boolean isValidSpec = specifiedGeneratorType != null && resolvedGenerator.getClass().isAssignableFrom(specifiedGeneratorType);
        String resolvedGeneratorName = Format.withoutPackage(resolvedGenerator.getClass());
        String specifiedGeneratorName = specifiedGeneratorType == null ? null : Format.withoutPackage(specifiedGeneratorType);
        StringBuilder sb = new StringBuilder(1024);
        ErrorMessageUtils.appendAnnotationHandlerMessageHeading(sb, annotationProcessorClass, method);
        sb.append(Constants.NL).append(" -> Annotation ...............: ").append(Format.withoutPackage(annotation.annotationType())).append(Constants.NL).append(" -> Annotated type ...........: ").append(Format.withoutPackage(node.getTargetClass())).append(Constants.NL).append(" -> Resolved generator spec ..: ").append(resolvedGeneratorName).append(Constants.NL).append(" -> Specified generator ......: ").append(specifiedGeneratorName);
        if (!isValidSpec) {
            sb.append(" (not valid)");
        }
        sb.append(Constants.NL).append(" -> Matched node .............: ").append(Format.nodePathToRootBlock(node)).append(Constants.NL).append(Constants.NL).append("To resolve this issue:").append(Constants.NL).append(Constants.NL).append(" -> check if the annotated type is compatible with the annotation").append(Constants.NL).append(" -> update the @AnnotationHandler method signature by specifying the correct generator spec class").append(Constants.NL).append(Constants.NL);
        ErrorMessageUtils.appendAnnotationHandlerUsage(sb);
        return sb.toString();
    }

    public static String annotationHandlerInvalidNumberOfParameters(Class<?> annotationProcessorClass, Method method) {
        Class<?>[] paramTypes = method.getParameterTypes();
        StringBuilder sb = new StringBuilder(1024);
        ErrorMessageUtils.appendAnnotationHandlerMessageHeading(sb, annotationProcessorClass, method);
        sb.append(Constants.NL).append("Invalid number of method parameters: ").append(paramTypes.length).append(Constants.NL).append(Constants.NL);
        ErrorMessageUtils.appendAnnotationHandlerUsage(sb);
        return sb.toString();
    }

    private static void appendAnnotationHandlerMessageHeading(StringBuilder sb, Class<?> annotationProcessorClass, Method method) {
        sb.append("invalid @AnnotationHandler method defined by ").append(annotationProcessorClass.getName()).append(Constants.NL).append(Constants.NL).append("    @AnnotationHandler").append(Constants.NL).append("    ").append(Format.methodNameWithParams(method)).append(Constants.NL);
    }

    private static void appendAnnotationHandlerUsage(StringBuilder sb) {
        sb.append("The accepted signatures for @AnnotationHandler methods are:").append(Constants.NL).append(Constants.NL).append(" -> void example(Annotation annotation, GeneratorSpec<?> spec)").append(Constants.NL).append(" -> void example(Annotation annotation, GeneratorSpec<?> spec, Node node)").append(Constants.NL).append(Constants.NL).append("where:").append(Constants.NL).append(Constants.NL).append(" - 'annotation' and 'spec' parameters can be subtypes of Annotation and GeneratorSpec, respectively.").append(Constants.NL).append(" - 'node' parameter is optional.").append(Constants.NL).append(Constants.NL).append("Example:").append(Constants.NL).append(Constants.NL).append("  @Retention(RetentionPolicy.RUNTIME)").append(Constants.NL).append("  public @interface HexString {").append(Constants.NL).append("      int length();").append(Constants.NL).append("  }").append(Constants.NL).append(Constants.NL).append("  @AnnotationHandler").append(Constants.NL).append("  void handleZipCode(HexString annotation, StringGeneratorSpec spec) {").append(Constants.NL).append("      spec.hex().length(annotation.length());").append(Constants.NL).append("  }");
    }

    public static String invalidStringTemplate(String template, String reason) {
        return new StringBuilder(1024).append("the specified template is invalid").append(Constants.NL).append(Constants.NL).append(" -> \"").append(template).append('\"').append(Constants.NL).append(Constants.NL).append("Cause: ").append(reason).toString();
    }

    public static String feedComponentMethodNotFound(Class<?> feedClass, String componentMethodName, SpecMethod specMethodDeclaringTheAnnotation) {
        return new StringBuilder(1024).append("invalid method name '").append(componentMethodName).append("' specified by the `@FunctionSpec.params` attribute in feed class:").append(Constants.NL).append(Constants.NL).append(" -> ").append(feedClass.getName()).append(Constants.NL).append(Constants.NL).append("To resolve this error:").append(Constants.NL).append(Constants.NL).append(" -> Check the annotation attributes of the following method:").append(Constants.NL).append(Constants.NL).append(Format.formatMethodWithFence(specMethodDeclaringTheAnnotation.getMethod())).toString();
    }

    public static String jacksonNotOnClasspathErrorMessage() {
        return new StringBuilder(1024).append("JSON feeds require 'jackson-databind' (not included with Instancio) to be on the classpath").append(Constants.NL).append(Constants.NL).append("To resolve this error:").append(Constants.NL).append(Constants.NL).append(" -> Add the following dependency:").append(Constants.NL).append(Constants.NL).append("    https://central.sonatype.com/artifact/com.fasterxml.jackson.core/jackson-databind").toString();
    }

    public static String feedDataSourceIoErrorMessage(DataSource dataSource, Exception ex) {
        StringBuilder sb = new StringBuilder(1024).append("failed loading feed data").append(Constants.NL);
        if (dataSource.getName() != null) {
            sb.append(Constants.NL).append(" -> Source: ").append(dataSource.getName()).append(Constants.NL);
        }
        return sb.append(Constants.NL).append("Root cause:").append(Constants.NL).append(Constants.NL).append(" -> ").append(ErrorMessageUtils.getRootCause(ex)).toString();
    }

    public static String feedWithoutDataSource(Class<?> feedClass) {
        return new StringBuilder(1024).append("no data source provided for feed ").append(feedClass.getName()).append(Constants.NL).append(Constants.NL).append("To resolve this error, please specify a data source using any of the options below.").append(Constants.NL).append(Constants.NL).append(" -> Via the @Feed.Source annotation:").append(Constants.NL).append(Constants.NL).append("    @Feed.Source(resource = \"path/to/data/sample.csv\")").append(Constants.NL).append("    interface SampleFeed extends Feed { ... }").append(Constants.NL).append(Constants.NL).append(" -> Using the builder API:").append(Constants.NL).append(Constants.NL).append("    import org.instancio.feed.DataSource;").append(Constants.NL).append(Constants.NL).append("    SampleFeed feed = Instancio.ofFeed(SampleFeed.class)").append(Constants.NL).append("        .withDataSource(myDataSource)").append(Constants.NL).append("        .create();").toString();
    }

    public static String feedWithInvalidMethodName(Class<?> feedClass, String invalidPropertyName, Collection<String> availableProperties) {
        String properties = String.join((CharSequence)", ", availableProperties);
        return new StringBuilder(1024).append("unmatched spec method '").append(invalidPropertyName).append("()' declared by the feed class").append(Constants.NL).append(Constants.NL).append(" -> ").append(feedClass.getName()).append(Constants.NL).append(Constants.NL).append("The property name '").append(invalidPropertyName).append("' does not map to any property in the data:").append(Constants.NL).append(Constants.NL).append(" -> [").append(properties).append(']').toString();
    }

    public static String feedDataEnd(Class<?> feedClass, Settings settings) {
        String dataAccessKey = ErrorMessageUtils.keyDesc(Keys.FEED_DATA_ACCESS);
        String dataEndKey = ErrorMessageUtils.keyDesc(Keys.FEED_DATA_END_ACTION);
        String currentDataAccess = ErrorMessageUtils.enumValueDesc(settings.get(Keys.FEED_DATA_ACCESS));
        String curentDataEndStrategy = ErrorMessageUtils.enumValueDesc(settings.get(Keys.FEED_DATA_END_ACTION));
        return new StringBuilder(1024).append("reached end of data for feed class").append(Constants.NL).append(Constants.NL).append(" -> ").append(feedClass.getName()).append(Constants.NL).append(Constants.NL).append("The error was triggered because of the following settings:").append(Constants.NL).append(Constants.NL).append(" -> ").append(dataAccessKey).append(" ......: ").append(currentDataAccess).append(Constants.NL).append(" -> ").append(dataEndKey).append(" ..: ").append(curentDataEndStrategy).append(Constants.NL).append(Constants.NL).append("To resolve this error:").append(Constants.NL).append(Constants.NL).append(" -> Ensure the data source provides a sufficient number of records").append(Constants.NL).append(" -> Set ").append(dataEndKey).append(" to ").append(ErrorMessageUtils.enumValueDesc(FeedDataEndAction.RECYCLE)).append(Constants.NL).append(" -> Set ").append(dataAccessKey).append(" to ").append(ErrorMessageUtils.enumValueDesc(FeedDataAccess.RANDOM)).append(Constants.NL).append(Constants.NL).append("Note that the last two options may result in duplicate values being produced.").toString();
    }

    public static String unmappedFeedProperties(Collection<String> unmappedProperties, Settings settings) {
        String properties = unmappedProperties.stream().sorted().collect(Collectors.joining(", "));
        String onFeedPropertyUnmatchedKey = ErrorMessageUtils.keyDesc(Keys.ON_FEED_PROPERTY_UNMATCHED);
        String currentOnFeedPropertyUnmatched = settings.get(Keys.ON_FEED_PROPERTY_UNMATCHED).toString();
        return new StringBuilder(1024).append("unmapped feed properties").append(Constants.NL).append(Constants.NL).append(" -> The feed specified in the applyFeed() method contains the following").append(Constants.NL).append("    properties that do not map to any field in the target class:").append(Constants.NL).append(Constants.NL).append("    ").append(properties).append(Constants.NL).append(Constants.NL).append("The error was triggered because of the following setting:").append(Constants.NL).append(Constants.NL).append(" -> ").append(onFeedPropertyUnmatchedKey).append(": ").append(currentOnFeedPropertyUnmatched).append(Constants.NL).append(Constants.NL).append("To resolve this error, consider one of the following:").append(Constants.NL).append(Constants.NL).append(" -> Ensure that each property in the feed has a corresponding field in the target class").append(Constants.NL).append(Constants.NL).append(" -> Update the ").append(onFeedPropertyUnmatchedKey).append(" setting to: ").append((Object)OnFeedPropertyUnmatched.IGNORE).append(Constants.NL).append("    if the unmatched properties are intentional").toString();
    }

    public static String invalidFunctionSpecHandlerMethod(Class<?> feedClass, Class<?> providerClass, SpecMethod parentSpecMethod) {
        return new StringBuilder(1024).append("the following FunctionProvider implementation should contain exactly one method:").append(Constants.NL).append(Constants.NL).append(" -> ").append(providerClass.getName()).append(Constants.NL).append(Constants.NL).append("The provider is referenced by:").append(Constants.NL).append(Constants.NL).append(Format.formatMethodWithFence(parentSpecMethod.getMethod())).append(Constants.NL).append(Constants.NL).append("declared by the feed class:").append(Constants.NL).append(Constants.NL).append(" -> ").append(feedClass.getName()).append(Constants.NL).append(Constants.NL).append("To resolve this error:").append(Constants.NL).append(Constants.NL).append(" -> Verify that the provider class contains exactly one method.").append(Constants.NL).append(Constants.NL).append(" -> Ensure the number of parameters and parameter types match the").append(Constants.NL).append("    parameters declared by the '@SpecFunction.params' attribute.").append(Constants.NL).toString();
    }

    public static String invalidSpecMethod(Method method) {
        return new StringBuilder(1024).append("invalid spec method '").append(method.getName()).append("()' declared by the feed class").append(Constants.NL).append(Constants.NL).append(" -> ").append(method.getDeclaringClass().getName()).append(Constants.NL).append(Constants.NL).append(Format.formatMethodWithFence(method)).append(Constants.NL).append(Constants.NL).append("To resolve this error:").append(Constants.NL).append(Constants.NL).append(" -> Ensure the spec method returns a FeedSpec<T>").append(Constants.NL).append(Constants.NL).append("    // Example").append(Constants.NL).append("    FeedSpec<Integer> age();").toString();
    }

    public static String errorMappingStringToTargetType(String propertyKey, String value, Exception ex) {
        return new StringBuilder(1024).append("error mapping String value to target type").append(Constants.NL).append(Constants.NL).append(" -> Property name ..: \"").append(propertyKey).append('\"').append(Constants.NL).append(" -> Value ..........: \"").append(value).append('\"').append(Constants.NL).append(Constants.NL).append("Root cause: ").append(ErrorMessageUtils.getRootCause(ex)).toString();
    }

    public static String errorInvokingFunctionSpecHandlerMethod(Class<?> feedClass, Class<?> providerClass, SpecMethod parentSpecMethod, Method specFunctionHandler, Exception ex) {
        String methodName = specFunctionHandler.getName();
        return new StringBuilder(1024).append("exception thrown by spec method '").append(parentSpecMethod.getMethod().getName()).append("()' declared by the feed class:").append(Constants.NL).append(Constants.NL).append(" -> ").append(feedClass.getName()).append(Constants.NL).append(Constants.NL).append("The error was caused by calling the method declared by ").append(Format.withoutPackage(providerClass)).append(':').append(Constants.NL).append(Constants.NL).append(Format.formatMethodWithFence(specFunctionHandler)).append(Constants.NL).append(Constants.NL).append("Root cause: ").append(ErrorMessageUtils.getRootCause(ex)).append(Constants.NL).append(Constants.NL).append("To resolve this error:").append(Constants.NL).append(Constants.NL).append(" -> Verify that the spec properties specified by the '@FunctionSpec.params' attribute").append(Constants.NL).append("    match the number of parameters and parameter types defined by the '").append(methodName).append("' method").append(Constants.NL).append(Constants.NL).append(" -> Ensure the method does not throw an exception").toString();
    }

    private static String keyDesc(SettingKey<?> key) {
        String keyName = key.propertyKey().replace('.', '_').toUpperCase(Locale.ROOT);
        return "Keys." + keyName;
    }

    private static String enumValueDesc(Enum<?> e) {
        return String.format("%s.%s", e.getClass().getSimpleName(), e.name());
    }

    private static Throwable getRootCause(Throwable t) {
        Throwable cause = t;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause;
    }
}

