/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.selectors;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Objects;
import org.instancio.Scope;
import org.instancio.internal.selectors.Target;
import org.instancio.internal.selectors.TargetField;
import org.instancio.internal.selectors.TargetFieldName;
import org.instancio.internal.selectors.TargetSetter;
import org.instancio.internal.selectors.TargetSetterName;
import org.instancio.internal.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ScopeImpl
implements Scope {
    private final Target target;
    private final Integer depth;

    public ScopeImpl(@NotNull Target target, @Nullable Integer depth) {
        this.target = target;
        this.depth = depth;
    }

    public Target getTarget() {
        return this.target;
    }

    public Class<?> getTargetClass() {
        return this.target.getTargetClass();
    }

    public Field getField() {
        return ((TargetField)this.target).getField();
    }

    public String getMethodName() {
        return ((TargetSetter)this.target).getSetter().getName();
    }

    public Class<?> getParameterType() {
        return ((TargetSetter)this.target).getParameterType();
    }

    public Integer getDepth() {
        return this.depth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ScopeImpl)) {
            return false;
        }
        ScopeImpl scope = (ScopeImpl)o;
        return Objects.equals(this.target, scope.target) && Objects.equals(this.depth, scope.depth);
    }

    public int hashCode() {
        int result = this.target.hashCode();
        result = 31 * result + (this.depth == null ? 0 : this.depth.hashCode());
        return result;
    }

    public String toString() {
        Target t;
        ArrayList<String> elements = new ArrayList<String>(4);
        if (this.target.getTargetClass() != null) {
            elements.add(this.target.getTargetClass().getSimpleName());
        }
        if (this.target instanceof TargetField) {
            t = (TargetField)this.target;
            elements.add(StringUtils.quoteStringValue(((TargetField)t).getField().getName()));
        }
        if (this.target instanceof TargetFieldName) {
            t = (TargetFieldName)this.target;
            elements.add(StringUtils.quoteStringValue(((TargetFieldName)t).getFieldName()));
        }
        if (this.target instanceof TargetSetter) {
            t = (TargetSetter)this.target;
            String methodName = ((TargetSetter)t).getSetter().getName();
            elements.add(((TargetSetter)t).getParameterType() == null ? methodName : String.format("%s(%s)", methodName, ((TargetSetter)t).getParameterType().getSimpleName()));
        }
        if (this.target instanceof TargetSetterName) {
            t = (TargetSetterName)this.target;
            elements.add(((TargetSetterName)t).getParameterType() == null ? ((TargetSetterName)t).getMethodName() : String.format("%s(%s)", ((TargetSetterName)t).getMethodName(), ((TargetSetterName)t).getParameterType().getSimpleName()));
        }
        if (this.depth != null) {
            elements.add(String.format("atDepth(%s)", this.depth));
        }
        return "scope(" + String.join((CharSequence)", ", elements) + ')';
    }
}

