/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.instancio.internal.nodes.ClassData;
import org.instancio.internal.nodes.DefaultPackageFilter;
import org.instancio.internal.nodes.DefaultSetterMethodResolver;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.nodes.MemberPair;
import org.instancio.internal.nodes.NodeKind;
import org.instancio.internal.nodes.PackageFilter;
import org.instancio.internal.util.MethodUtils;
import org.instancio.internal.util.SetterMethodComparator;
import org.instancio.settings.AssignmentType;
import org.instancio.settings.Keys;
import org.instancio.settings.OnSetMethodUnmatched;
import org.instancio.settings.SetterStyle;
import org.instancio.settings.Settings;
import org.jetbrains.annotations.Nullable;

class DeclaredAndInheritedMemberCollector {
    private static final Comparator<Method> METHOD_COMPARATOR = new SetterMethodComparator();
    private final PackageFilter packageFilter = new DefaultPackageFilter();
    private final DefaultSetterMethodResolver defaultSetterMethodResolver;
    private final boolean isMethodAssignmentEnabled;
    private final boolean ignoreUnmatchedSetters;
    private final String setterPrefix;
    private final int setterExcludeModifiers;

    DeclaredAndInheritedMemberCollector(Settings settings) {
        this.isMethodAssignmentEnabled = settings.get(Keys.ASSIGNMENT_TYPE) == AssignmentType.METHOD;
        this.ignoreUnmatchedSetters = settings.get(Keys.ON_SET_METHOD_UNMATCHED) == OnSetMethodUnmatched.IGNORE;
        this.setterPrefix = this.getSetterPrefix(settings.get(Keys.SETTER_STYLE));
        this.setterExcludeModifiers = settings.get(Keys.SETTER_EXCLUDE_MODIFIER);
        this.defaultSetterMethodResolver = new DefaultSetterMethodResolver(settings);
    }

    ClassData getClassData(InternalNode node) {
        Class<?> klass = node.getTargetClass();
        List<Field> fields = this.getNonStaticFields(klass);
        boolean isRecord = node.getNodeKind() == NodeKind.RECORD;
        Set<Method> unmatchedSetters = isRecord ? Collections.emptySet() : this.getSetters(klass);
        ArrayList<MemberPair> memberPairs = new ArrayList<MemberPair>();
        for (Field field : fields) {
            Method matchedSetter = null;
            if (!isRecord && this.isMethodAssignmentEnabled && !Modifier.isFinal(field.getModifiers()) && (matchedSetter = this.defaultSetterMethodResolver.getSetter(field)) != null) {
                unmatchedSetters.remove(matchedSetter);
            }
            memberPairs.add(new MemberPair(field, matchedSetter));
        }
        return this.ignoreUnmatchedSetters ? new ClassData(memberPairs, Collections.emptySet()) : new ClassData(memberPairs, unmatchedSetters);
    }

    private List<Field> getNonStaticFields(Class<?> klass) {
        Class<?> nextClass = klass;
        ArrayList<Field> collected = new ArrayList<Field>();
        while (this.shouldCollectFrom(nextClass)) {
            for (Field field : nextClass.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                collected.add(field);
            }
            nextClass = nextClass.getSuperclass();
        }
        return collected;
    }

    private boolean shouldCollectFrom(@Nullable Class<?> c) {
        return c != null && !c.isInterface() && !c.isArray() && c != Object.class && !this.packageFilter.isExcluded(c.getPackage());
    }

    private String getSetterPrefix(SetterStyle setterStyle) {
        if (setterStyle == SetterStyle.SET) {
            return "set";
        }
        if (setterStyle == SetterStyle.WITH) {
            return "with";
        }
        return null;
    }

    private Set<Method> getSetters(Class<?> klass) {
        if (!this.isMethodAssignmentEnabled || this.setterPrefix == null) {
            return Collections.emptySet();
        }
        TreeSet<Method> collected = new TreeSet<Method>(METHOD_COMPARATOR);
        HashSet<MethodKey> seenMethods = new HashSet<MethodKey>();
        Class<?> nextClass = klass;
        while (this.shouldCollectFrom(nextClass)) {
            for (Method method : nextClass.getDeclaredMethods()) {
                MethodKey methodKey;
                int modifiers = method.getModifiers();
                if (method.getParameterCount() != 1 || MethodUtils.isExcluded(modifiers, this.setterExcludeModifiers) || !method.getName().startsWith(this.setterPrefix) || !seenMethods.add(methodKey = new MethodKey(method))) continue;
                collected.add(method);
            }
            nextClass = nextClass.getSuperclass();
        }
        return collected;
    }

    static final class MethodKey {
        private final String name;
        private final Class<?> parameterType;

        private MethodKey(Method method) {
            this.name = method.getName();
            this.parameterType = method.getParameterTypes()[0];
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MethodKey)) {
                return false;
            }
            MethodKey methodKey = (MethodKey)o;
            return this.name.equals(methodKey.name) && this.parameterType.equals(methodKey.parameterType);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.parameterType.hashCode();
            return result;
        }
    }
}

