/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.util;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.instancio.Random;
import org.instancio.generator.AfterGenerate;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.Hints;
import org.instancio.generator.hints.CollectionHint;
import org.instancio.generator.specs.CollectionGeneratorSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.ErrorHandler;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.InternalGeneratorHint;
import org.instancio.internal.util.CollectionUtils;
import org.instancio.internal.util.ExceptionUtils;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.NumberUtils;
import org.instancio.internal.util.ReflectionUtils;
import org.instancio.settings.Keys;

public class CollectionGenerator<T>
extends AbstractGenerator<Collection<T>>
implements CollectionGeneratorSpec<T> {
    private static final Class<?> DEFAULT_COLLECTION_TYPE = ArrayList.class;
    protected int minSize;
    protected int maxSize;
    private boolean nullableElements;
    private boolean unique;
    private List<Object> withElements;
    protected Class<?> collectionType;

    public CollectionGenerator(GeneratorContext context) {
        super(context);
        this.minSize = context.getSettings().get(Keys.COLLECTION_MIN_SIZE);
        this.maxSize = context.getSettings().get(Keys.COLLECTION_MAX_SIZE);
        super.nullable(context.getSettings().get(Keys.COLLECTION_NULLABLE));
        this.nullableElements = context.getSettings().get(Keys.COLLECTION_ELEMENTS_NULLABLE);
        this.collectionType = DEFAULT_COLLECTION_TYPE;
    }

    @Override
    public String apiMethod() {
        return "collection()";
    }

    @Override
    public CollectionGenerator<T> size(int size) {
        this.minSize = ApiValidator.validateSize(size);
        this.maxSize = size;
        return this;
    }

    @Override
    public CollectionGenerator<T> minSize(int size) {
        this.minSize = ApiValidator.validateSize(size);
        this.maxSize = NumberUtils.calculateNewMaxSize(this.maxSize, this.minSize);
        return this;
    }

    @Override
    public CollectionGenerator<T> maxSize(int size) {
        this.maxSize = ApiValidator.validateSize(size);
        this.minSize = NumberUtils.calculateNewMinSize(this.minSize, this.maxSize);
        return this;
    }

    @Override
    public CollectionGenerator<T> nullable() {
        super.nullable();
        return this;
    }

    @Override
    public CollectionGenerator<T> nullable(boolean isNullable) {
        super.nullable(isNullable);
        return this;
    }

    @Override
    public CollectionGenerator<T> nullableElements() {
        this.nullableElements = true;
        return this;
    }

    @Override
    public CollectionGenerator<T> subtype(Class<?> type) {
        this.collectionType = ApiValidator.notNull(type, "type must not be null");
        return this;
    }

    @Override
    public CollectionGenerator<T> unique() {
        this.unique = true;
        return this;
    }

    @Override
    @SafeVarargs
    public final CollectionGenerator<T> with(T ... elements) {
        ApiValidator.notEmpty(elements, "'collection().with(...)' must contain at least one element", new Object[0]);
        if (this.withElements == null) {
            this.withElements = new ArrayList<Object>();
        }
        Collections.addAll(this.withElements, elements);
        return this;
    }

    @Override
    protected Collection<T> tryGenerateNonNull(Random random) {
        try {
            Constructor<?> ctor = ReflectionUtils.setAccessible(this.collectionType.getDeclaredConstructor(new Class[0]));
            return (Collection)ctor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            String msg = String.format("Error creating instance of: %s", this.collectionType);
            if (ErrorHandler.shouldFailOnError(this.getContext().getSettings())) {
                throw Fail.withFataInternalError(msg, ex);
            }
            ExceptionUtils.logException(msg, ex, new Object[0]);
            return null;
        }
    }

    @Override
    public Hints hints() {
        return Hints.builder().afterGenerate(AfterGenerate.POPULATE_ALL).with(CollectionHint.builder().generateElements(this.getContext().random().intRange(this.minSize, this.maxSize)).nullableElements(this.nullableElements).withElements(this.withElements).unique(this.unique).shuffle(!CollectionUtils.isNullOrEmpty(this.withElements)).build()).with(InternalGeneratorHint.builder().targetClass(this.collectionType).delegating(this.isDelegating()).nullableResult(this.isNullable()).build()).build();
    }
}

