/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.util;

import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.TemporalSpec;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.time.ZonedDateTimeGenerator;

public class CalendarGenerator
extends AbstractGenerator<Calendar>
implements TemporalSpec<Calendar> {
    private final ZonedDateTimeGenerator delegate;

    public CalendarGenerator(GeneratorContext context) {
        super(context);
        this.delegate = new ZonedDateTimeGenerator(context);
    }

    @Override
    public String apiMethod() {
        return "calendar()";
    }

    @Override
    public CalendarGenerator past() {
        this.delegate.past();
        return this;
    }

    @Override
    public CalendarGenerator future() {
        this.delegate.future();
        return this;
    }

    public CalendarGenerator min(Calendar min) {
        this.delegate.min(ZonedDateTime.ofInstant(min.toInstant(), min.getTimeZone().toZoneId()));
        return this;
    }

    public CalendarGenerator max(Calendar max) {
        this.delegate.max(ZonedDateTime.ofInstant(max.toInstant(), max.getTimeZone().toZoneId()));
        return this;
    }

    public CalendarGenerator range(Calendar min, Calendar max) {
        this.delegate.range(ZonedDateTime.ofInstant(min.toInstant(), min.getTimeZone().toZoneId()), ZonedDateTime.ofInstant(max.toInstant(), max.getTimeZone().toZoneId()));
        return this;
    }

    @Override
    public CalendarGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected Calendar tryGenerateNonNull(Random random) {
        return GregorianCalendar.from(this.delegate.tryGenerateNonNull(random));
    }
}

