/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.lang;

import java.math.BigDecimal;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.NumberGeneratorSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.lang.AbstractRandomNumberGeneratorSpec;
import org.instancio.internal.generator.specs.InternalNumberGeneratorSpec;
import org.instancio.internal.util.NumberUtils;
import org.instancio.internal.util.NumericBounds;

public abstract class AbstractRandomComparableNumberGeneratorSpec<T extends Number>
extends AbstractRandomNumberGeneratorSpec<T>
implements InternalNumberGeneratorSpec<T> {
    protected AbstractRandomComparableNumberGeneratorSpec(GeneratorContext context, T min, T max, boolean nullable) {
        super(context, min, max, nullable);
    }

    @Override
    public NumberGeneratorSpec<T> min(T min) {
        super.min(min);
        super.max(NumberUtils.calculateNewMax(this.getMax(), min, 50));
        return this;
    }

    @Override
    public NumberGeneratorSpec<T> max(T max) {
        super.max(max);
        super.min(NumberUtils.calculateNewMin(this.getMin(), max, 50));
        return this;
    }

    @Override
    public NumberGeneratorSpec<T> range(T min, T max) {
        super.range(min, max);
        ApiValidator.isTrue(((Comparable)min).compareTo(max) <= 0, "invalid 'range(%s, %s)': lower bound must be less than or equal to upper bound", min, max);
        return this;
    }

    @Override
    public void ensureMinIsGreaterThanOrEqualTo(BigDecimal otherMin) {
        Object currentMin = this.getMin();
        Number newMin = (Number)NumberUtils.bigDecimalConverter(currentMin.getClass()).apply(otherMin);
        if (((Comparable)((Object)newMin)).compareTo(currentMin) > 0) {
            this.min(newMin);
        }
    }

    @Override
    public void ensureMaxIsLessThanOrEqualTo(BigDecimal otherMax) {
        Object currentMax = this.getMax();
        Number newMax = (Number)NumberUtils.bigDecimalConverter(currentMax.getClass()).apply(otherMax);
        if (((Comparable)((Object)newMax)).compareTo(currentMax) < 0) {
            this.max(newMax);
        }
    }

    @Override
    public void integerMax(int integerMax) {
        Class<?> targetClass = this.getMin().getClass();
        BigDecimal currentMin = NumberUtils.toBigDecimal(this.getMin());
        BigDecimal currentMax = NumberUtils.toBigDecimal(this.getMax());
        NumericBounds updatedBounds = new NumericBounds(currentMin, currentMax).updateBounds(integerMax);
        BigDecimal newMinBD = updatedBounds.getMin().max(NumberUtils.toBigDecimal(NumberUtils.getMinValue(targetClass))).max(currentMin);
        BigDecimal newMaxBD = updatedBounds.getMax().min(NumberUtils.toBigDecimal(NumberUtils.getMaxValue(targetClass))).min(currentMax);
        Number newMin = (Number)NumberUtils.bigDecimalConverter(targetClass).apply(newMinBD);
        Number newMax = (Number)NumberUtils.bigDecimalConverter(targetClass).apply(newMaxBD);
        this.min(newMin);
        this.max(newMax);
    }
}

