/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.domain.id.usa;

import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.usa.SsnSpec;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.util.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class SsnGenerator
extends AbstractGenerator<String>
implements SsnSpec {
    private static final int SSN_LENGTH = 9;
    private String separator;

    public SsnGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return "ssn()";
    }

    @Override
    public SsnGenerator separator(String separator) {
        this.separator = separator;
        return this;
    }

    @Override
    public SsnGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected String tryGenerateNonNull(Random random) {
        String ssn = this.generateValidSsn(random);
        if (this.separator == null) {
            return ssn;
        }
        return ssn.substring(0, 3) + this.separator + ssn.substring(3, 5) + this.separator + ssn.substring(5, 9);
    }

    private String generateValidSsn(Random random) {
        String ssn = random.digits(9);
        while (SsnGenerator.isInvalid(ssn)) {
            ssn = random.digits(9);
        }
        return ssn;
    }

    @VisibleForTesting
    static boolean isInvalid(String ssn) {
        return ssn.charAt(3) == '0' && ssn.charAt(4) == '0' || ssn.endsWith("0000") || StringUtils.startsWithAny(ssn, "000", "666", "9", "078051120", "219099999", "123456789");
    }
}

