/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.instancio.exception.InstancioException;
import org.instancio.exception.InstancioTerminatingException;
import org.instancio.generator.Generator;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.spi.ProviderEntry;
import org.instancio.internal.util.ErrorMessageUtils;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.ReflectionUtils;
import org.instancio.spi.InstancioServiceProvider;

class AnnotationProcessorHelper {
    private final Map<Class<?>, List<AnnotatedMethod>> annotationProcessorMethods;

    AnnotationProcessorHelper(List<ProviderEntry<InstancioServiceProvider.AnnotationProcessor>> annotationProcessors) {
        this.annotationProcessorMethods = AnnotationProcessorHelper.collectAnnotationProcessorMethods(annotationProcessors);
    }

    List<AnnotatedMethod> get(Class<? extends Annotation> annotationType) {
        return this.annotationProcessorMethods.getOrDefault(annotationType, Collections.emptyList());
    }

    private static Map<Class<?>, List<AnnotatedMethod>> collectAnnotationProcessorMethods(List<ProviderEntry<InstancioServiceProvider.AnnotationProcessor>> annotationProcessors) {
        if (annotationProcessors.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Class, List> results = new LinkedHashMap<Class, List>();
        for (ProviderEntry<InstancioServiceProvider.AnnotationProcessor> entry : annotationProcessors) {
            InstancioServiceProvider.AnnotationProcessor processor = entry.getProvider();
            for (Method method : processor.getClass().getDeclaredMethods()) {
                ReflectionUtils.setAccessible(method);
                if (method.getDeclaredAnnotation(InstancioServiceProvider.AnnotationProcessor.AnnotationHandler.class) == null) continue;
                Class<?>[] paramTypes = method.getParameterTypes();
                AnnotatedMethod annotatedMethod = new AnnotatedMethod(processor, method);
                if (paramTypes.length <= 0) continue;
                Class<?> annotationType = paramTypes[0];
                results.computeIfAbsent(annotationType, v -> new ArrayList()).add(annotatedMethod);
            }
        }
        return Collections.unmodifiableMap(results);
    }

    static final class AnnotatedMethod {
        private final InstancioServiceProvider.AnnotationProcessor processor;
        private final Method method;
        private final Class<?>[] params;

        AnnotatedMethod(InstancioServiceProvider.AnnotationProcessor processor, Method method) {
            this.processor = processor;
            this.method = method;
            this.params = method.getParameterTypes();
        }

        void invoke(Annotation annotation, Generator<?> generator, InternalNode node) {
            block6: {
                try {
                    if (this.params.length == 2) {
                        this.method.invoke((Object)this.processor, annotation, generator);
                        break block6;
                    }
                    if (this.params.length == 3) {
                        this.method.invoke((Object)this.processor, annotation, generator, node);
                        break block6;
                    }
                    throw Fail.withUsageError(ErrorMessageUtils.annotationHandlerInvalidNumberOfParameters(this.processor.getClass(), this.method), new Object[0]);
                }
                catch (IllegalArgumentException ex) {
                    String msg = ErrorMessageUtils.invalidAnnotationHandlerMethod(this.processor.getClass(), this.method, annotation, generator, node);
                    throw Fail.withUsageError(msg, ex);
                }
                catch (AssertionError | InstancioTerminatingException ex) {
                    throw ex;
                }
                catch (Exception ex) {
                    throw new InstancioException("Failed invoking @AnnotationHandler method", ex);
                }
            }
        }
    }
}

