/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.feed;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.instancio.exception.InstancioTerminatingException;
import org.instancio.feed.DataSource;
import org.instancio.internal.feed.DataLoader;
import org.instancio.internal.feed.DataStore;
import org.instancio.internal.feed.InternalFeedContext;
import org.instancio.internal.feed.datasource.CacheableDataSource;
import org.instancio.internal.util.ErrorMessageUtils;
import org.instancio.internal.util.Fail;
import org.jetbrains.annotations.NotNull;

public class CachingDataLoader {
    private static final Map<Object, DataStore<?>> CACHE = new ConcurrentHashMap();

    @NotNull
    public DataStore<?> loadData(InternalFeedContext<?> feedContext, DataLoader<?> dataLoader, BiFunction<String, List<?>, DataStore<?>> tagKeyToDataStoreMapper) {
        Object cacheKey;
        DataSource dataSource = feedContext.getDataSource();
        String tagKey = feedContext.getTagKey();
        Object object = cacheKey = dataSource instanceof CacheableDataSource ? ((CacheableDataSource)dataSource).getKey() : null;
        if (cacheKey == null) {
            List<?> data = CachingDataLoader.tryLoad(dataLoader, dataSource);
            return tagKeyToDataStoreMapper.apply(tagKey, data);
        }
        return CACHE.computeIfAbsent(cacheKey, mapKey -> {
            List<?> data = CachingDataLoader.tryLoad(dataLoader, dataSource);
            return (DataStore)tagKeyToDataStoreMapper.apply(tagKey, data);
        });
    }

    private static List<?> tryLoad(DataLoader<?> dataLoader, DataSource dataSource) {
        try {
            return (List)dataLoader.load(dataSource);
        }
        catch (InstancioTerminatingException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw Fail.withUsageError(ErrorMessageUtils.feedDataSourceIoErrorMessage(dataSource, ex), ex);
        }
    }
}

