/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.feed;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.feed.DataStore;

public abstract class AbstractDataStore<R>
implements DataStore<R> {
    private final List<R> data;
    private final String tagKey;
    private final Map<String, Integer> fieldIndexMap;
    private final List<String> tagKeys;
    private final Map<String, List<R>> groupedByTag;

    protected AbstractDataStore(String tagKey, List<R> data) {
        ApiValidator.isFalse(data.isEmpty(), "empty data source", new Object[0]);
        this.data = Collections.unmodifiableList(data);
        this.tagKey = tagKey;
        this.fieldIndexMap = this.createFieldIndexMap(data);
        this.groupedByTag = this.groupDataByTag(tagKey, this.fieldIndexMap, data);
        this.tagKeys = Collections.unmodifiableList(new ArrayList<String>(this.groupedByTag.keySet()));
    }

    protected abstract Map<String, Integer> createFieldIndexMap(List<R> var1);

    protected abstract Map<String, List<R>> groupDataByTag(String var1, Map<String, Integer> var2, List<R> var3);

    protected final List<R> getData() {
        return this.data;
    }

    @Override
    public final List<R> get(String tagValue) {
        List<R> tagData = this.groupedByTag.get(tagValue);
        ApiValidator.notNull(tagData, () -> String.format("no data found with tag value: '%s' (tagKey is set to: '%s')", tagValue, this.tagKey));
        return tagData;
    }

    @Override
    public final int indexOf(String propertyName) {
        return this.fieldIndexMap.getOrDefault(propertyName, -1);
    }

    @Override
    public final boolean contains(String propertyName) {
        return this.fieldIndexMap.containsKey(propertyName);
    }

    @Override
    public final Set<String> getPropertyKeys() {
        return this.fieldIndexMap.keySet();
    }

    @Override
    public final List<String> getTagKeys() {
        return this.tagKeys;
    }
}

