/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.context;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.instancio.GeneratorSpecProvider;
import org.instancio.TargetSelector;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.generators.Generators;
import org.instancio.internal.context.GeneratorInitialiser;
import org.instancio.internal.context.SelectorMap;
import org.instancio.internal.context.SelectorMapImpl;
import org.instancio.internal.generators.BuiltInGenerators;
import org.instancio.internal.nodes.InternalNode;
import org.jetbrains.annotations.NotNull;

class GeneratorSelectorMap {
    private final GeneratorInitialiser generatorInitialiser;
    private final SelectorMap<Generator<?>> selectorMap = new SelectorMapImpl();
    private final Generators generators;

    GeneratorSelectorMap(@NotNull GeneratorContext generatorContext) {
        this.generators = new BuiltInGenerators(generatorContext);
        this.generatorInitialiser = new GeneratorInitialiser(generatorContext);
    }

    void putGenerator(TargetSelector targetSelector, Generator<?> generator) {
        this.addToSelectorMap(targetSelector, generator);
    }

    void putGeneratorSpec(TargetSelector targetSelector, GeneratorSpecProvider<?> genFn) {
        this.addToSelectorMap(targetSelector, (Generator)genFn.getSpec(this.generators));
    }

    void putAllGenerators(Map<TargetSelector, Generator<?>> generatorMap) {
        for (Map.Entry<TargetSelector, Generator<?>> entry : generatorMap.entrySet()) {
            this.putGenerator(entry.getKey(), entry.getValue());
        }
    }

    void putAllGeneratorSpecs(Map<TargetSelector, GeneratorSpecProvider<?>> specs) {
        for (Map.Entry<TargetSelector, GeneratorSpecProvider<?>> entry : specs.entrySet()) {
            this.putGeneratorSpec(entry.getKey(), entry.getValue());
        }
    }

    private void addToSelectorMap(TargetSelector targetSelector, Generator<?> g) {
        Generator<?> generator = this.generatorInitialiser.initGenerator(targetSelector, g);
        this.selectorMap.put(targetSelector, generator);
    }

    SelectorMap<Generator<?>> getSelectorMap() {
        return this.selectorMap;
    }

    Map<TargetSelector, Class<?>> getSubtypeMap() {
        return Collections.unmodifiableMap(this.generatorInitialiser.getSubtypeMap());
    }

    Optional<Generator<?>> getGenerator(InternalNode node) {
        return this.selectorMap.getValue(node);
    }
}

