/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.RandomAccess;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.Verify;

public final class CartesianList<E>
extends AbstractList<List<E>>
implements RandomAccess {
    private final List<List<E>> axes;
    private final int[] axesSizeProduct;

    public static <E> List<List<E>> create(List<? extends List<? extends E>> lists) {
        ArrayList<List<ArrayList<E>>> axesBuilder = new ArrayList<List<ArrayList<E>>>(lists.size());
        for (List<E> list : lists) {
            ArrayList<E> copy = new ArrayList<E>(list);
            Verify.isFalse(copy.isEmpty(), "Input list must not be empty", new Object[0]);
            axesBuilder.add(copy);
        }
        return new CartesianList<E>(axesBuilder);
    }

    private CartesianList(List<List<E>> axes) {
        this.axes = axes;
        int[] axesSize = new int[axes.size() + 1];
        axesSize[axes.size()] = 1;
        try {
            for (int i = axes.size() - 1; i >= 0; --i) {
                axesSize[i] = CartesianList.checkedMultiply(axesSize[i + 1], axes.get(i).size());
            }
        }
        catch (ArithmeticException ex) {
            throw Fail.withUsageError("Cartesian product too large; must have size at most Integer.MAX_VALUE", ex);
        }
        this.axesSizeProduct = axesSize;
    }

    private int getAxisIndexForProductIndex(int index, int axis) {
        return index / this.axesSizeProduct[axis + 1] % this.axes.get(axis).size();
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<E> get(final int index) {
        return new ArrayList<E>(){

            @Override
            public int size() {
                return CartesianList.this.axes.size();
            }

            @Override
            public E get(int axis) {
                int axisIndex = CartesianList.this.getAxisIndexForProductIndex(index, axis);
                return ((List)CartesianList.this.axes.get(axis)).get(axisIndex);
            }
        };
    }

    @Override
    public int size() {
        return this.axesSizeProduct[0];
    }

    @Override
    public boolean contains(Object object) {
        throw new UnsupportedOperationException();
    }

    private static int checkedMultiply(int a, int b) {
        long result = (long)a * (long)b;
        CartesianList.checkNoOverflow(result == (long)((int)result), "checkedMultiply", a, b);
        return (int)result;
    }

    private static void checkNoOverflow(boolean condition, String methodName, int a, int b) {
        if (!condition) {
            throw new ArithmeticException("overflow: " + methodName + "(" + a + ", " + b + ")");
        }
    }
}

