/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.nodes;

import java.lang.reflect.Field;
import org.instancio.internal.nodes.MethodNameResolver;

class SetterMethodNameWithPrefixResolver
implements MethodNameResolver {
    private final String prefix;

    SetterMethodNameWithPrefixResolver(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public String resolveFor(Field field) {
        return field.getType() == Boolean.TYPE || field.getType() == Boolean.class ? this.getBooleanMethodNameWithPrefix(field) : this.getMethodNameWithPrefix(field.getName());
    }

    private String getMethodNameWithPrefix(String fieldName) {
        char[] chars = fieldName.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return this.prefix + new String(chars);
    }

    private String getBooleanMethodNameWithPrefix(Field field) {
        String fieldName = field.getName();
        if (fieldName.startsWith("is")) {
            if (fieldName.length() > 2) {
                char[] chars = fieldName.toCharArray();
                chars[2] = Character.toUpperCase(chars[2]);
                return this.prefix + new String(chars, 2, chars.length - 2);
            }
            return null;
        }
        return this.getMethodNameWithPrefix(field.getName());
    }
}

