/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.instantiation;

import org.instancio.internal.instantiation.InstantiationStrategy;
import org.instancio.internal.instantiation.UnsafeHelper;
import org.instancio.internal.util.ReflectionUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class UnsafeInstantiationStrategy
implements InstantiationStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(UnsafeInstantiationStrategy.class);
    private final boolean isUnsafeAvailable;

    private UnsafeInstantiationStrategy() {
        boolean bl = this.isUnsafeAvailable = ReflectionUtils.loadClass("sun.misc.Unsafe") != null;
        if (!this.isUnsafeAvailable) {
            LOG.debug(String.format("sun.misc.Unsafe is unavailable. This may result in nulls being generated%nfor POJO classes that do not provide a default (no-argument) constructor.%nIf using JPMS, consider adding 'requires jdk.unsupported' to module-info.java", new Object[0]));
        }
    }

    static InstantiationStrategy getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public <T> T createInstance(Class<T> klass) {
        return this.isUnsafeAvailable() ? (T)UnsafeHelper.getInstance().allocateInstance(klass) : null;
    }

    @VisibleForTesting
    boolean isUnsafeAvailable() {
        return this.isUnsafeAvailable;
    }

    private static final class Holder {
        private static final InstantiationStrategy INSTANCE = new UnsafeInstantiationStrategy();

        private Holder() {
        }
    }
}

