/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.time;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.chrono.ChronoLocalDateTime;
import java.time.temporal.TemporalUnit;
import org.instancio.Random;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.specs.LocalDateTimeGeneratorAsSpec;
import org.instancio.generator.specs.LocalDateTimeSpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.time.InstantGenerator;
import org.instancio.internal.generator.time.JavaTimeTemporalGenerator;
import org.instancio.internal.util.Constants;
import org.instancio.support.Global;

public class LocalDateTimeGenerator
extends JavaTimeTemporalGenerator<LocalDateTime>
implements LocalDateTimeSpec,
LocalDateTimeGeneratorAsSpec {
    static final LocalDateTime DEFAULT_MIN = Constants.DEFAULT_MIN;
    static final LocalDateTime DEFAULT_MAX = Constants.DEFAULT_MAX;
    private final InstantGenerator delegate;

    public LocalDateTimeGenerator() {
        this(Global.generatorContext());
    }

    public LocalDateTimeGenerator(GeneratorContext context) {
        super(context, DEFAULT_MIN, DEFAULT_MAX);
        this.delegate = new InstantGenerator(context);
    }

    @Override
    public String apiMethod() {
        return "localDateTime()";
    }

    @Override
    public LocalDateTimeGenerator past() {
        super.past();
        return this;
    }

    @Override
    public LocalDateTimeGenerator future() {
        super.future();
        return this;
    }

    @Override
    public LocalDateTimeGenerator range(LocalDateTime start, LocalDateTime end) {
        super.range(start, end);
        return this;
    }

    @Override
    public LocalDateTimeGenerator truncatedTo(TemporalUnit unit) {
        super.truncatedTo(unit);
        return this;
    }

    @Override
    public LocalDateTimeGenerator nullable() {
        super.nullable();
        return this;
    }

    @Override
    LocalDateTime getLatestPast() {
        return LocalDateTime.now().minusSeconds(1L);
    }

    @Override
    LocalDateTime getEarliestFuture() {
        return LocalDateTime.now().plusMinutes(1L);
    }

    @Override
    void validateRange() {
        ApiValidator.validateStartEnd((ChronoLocalDateTime)this.min, (ChronoLocalDateTime)this.max);
    }

    @Override
    protected LocalDateTime tryGenerateNonNull(Random random) {
        this.delegate.range(((LocalDateTime)this.min).toInstant(Constants.ZONE_OFFSET), ((LocalDateTime)this.max).toInstant(Constants.ZONE_OFFSET));
        LocalDateTime result = LocalDateTime.ofInstant((Instant)this.delegate.generate(random), Constants.ZONE_OFFSET);
        return this.truncateTo == null ? result : result.truncatedTo(this.truncateTo);
    }
}

