/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator;

import java.util.HashMap;
import java.util.Map;
import org.instancio.generator.Generator;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.GeneratorSpec;
import org.instancio.generator.specs.SubtypeGeneratorSpec;
import org.instancio.internal.generator.GeneratorResolverMaps;
import org.instancio.internal.generator.GeneratorUtil;
import org.instancio.internal.generator.array.ArrayGenerator;
import org.instancio.internal.generator.lang.EnumGenerator;
import org.instancio.internal.generator.util.CollectionGenerator;
import org.instancio.internal.generator.util.MapGenerator;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.nodes.NodeKind;
import org.instancio.internal.util.ReflectionUtils;
import org.jetbrains.annotations.Nullable;

public class GeneratorResolver {
    private final GeneratorContext context;
    private final Map<Class<?>, Generator<?>> cache = new HashMap();

    public GeneratorResolver(GeneratorContext context) {
        this.context = context;
    }

    public Generator<?> get(InternalNode node) {
        Class<?> klass = node.getTargetClass();
        GeneratorSpec<Object> generator = this.getBuiltInGenerator(klass);
        if (generator == null) {
            generator = klass.isArray() ? new ArrayGenerator(this.context, klass) : (klass.isEnum() ? new EnumGenerator(this.context, klass) : (node.is(NodeKind.MAP) ? new MapGenerator(this.context).subtype((Class)node.getTargetClass()) : (node.is(NodeKind.COLLECTION) ? new CollectionGenerator(this.context).subtype((Class)node.getTargetClass()) : this.getGeneratorForLegacyClass(klass))));
        }
        return generator;
    }

    public Generator<?> getCached(InternalNode node) {
        Class<?> targetClass = node.getTargetClass();
        Generator<?> generator = this.cache.get(targetClass);
        if (generator == null) {
            generator = this.get(node);
            this.cache.put(targetClass, generator);
        }
        return generator;
    }

    @Nullable
    private Generator<?> getGeneratorForLegacyClass(Class<?> klass) {
        if ("java.sql.Date".equals(klass.getName())) {
            return GeneratorResolver.loadByClassName(this.context, "org.instancio.internal.generator.sql.SqlDateGenerator");
        }
        if ("java.sql.Timestamp".equals(klass.getName())) {
            return GeneratorResolver.loadByClassName(this.context, "org.instancio.internal.generator.sql.TimestampGenerator");
        }
        if ("javax.xml.datatype.XMLGregorianCalendar".equals(klass.getName())) {
            return GeneratorResolver.loadByClassName(this.context, "org.instancio.internal.generator.xml.XMLGregorianCalendarGenerator");
        }
        return null;
    }

    private static Generator<?> loadByClassName(GeneratorContext context, String generatorClassName) {
        Class<?> generatorClass = ReflectionUtils.loadClass(generatorClassName);
        return GeneratorUtil.instantiateInternalGenerator(generatorClass, context);
    }

    public Generator<?> getCachedBuiltInGenerator(Class<?> targetClass) {
        Generator<?> generator = this.cache.get(targetClass);
        if (generator == null) {
            this.cache.put(targetClass, generator);
            generator = this.getBuiltInGenerator(targetClass);
        }
        return generator;
    }

    private Generator<?> getBuiltInGenerator(Class<?> targetClass) {
        Class<?> subtype;
        Class<?> genClass = GeneratorResolverMaps.getGenerator(targetClass);
        if (genClass == null) {
            return this.getGeneratorForLegacyClass(targetClass);
        }
        Generator generator = GeneratorUtil.instantiateInternalGenerator(genClass, this.context);
        if (generator instanceof SubtypeGeneratorSpec && (subtype = GeneratorResolverMaps.getSubtype(targetClass)) != null) {
            ((SubtypeGeneratorSpec)((Object)generator)).subtype(subtype);
        }
        return generator;
    }
}

