/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generation;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import org.instancio.TargetSelector;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generation.GenerationListener;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.nodes.InternalNode;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneratedObjectStore
implements GenerationListener {
    private static final Logger LOG = LoggerFactory.getLogger(GeneratedObjectStore.class);
    private static final GeneratorResult EMPTY_RESULT = GeneratorResult.emptyResult();
    private final Map<Object, Map<TargetSelector, GeneratorResult>> objectStore = new IdentityHashMap<Object, Map<TargetSelector, GeneratorResult>>();
    private final Deque<Object> scopes = new ArrayDeque<Object>();
    private final ModelContext<?> context;
    private boolean hasNewValues;

    private GeneratedObjectStore(ModelContext<?> context) {
        this.context = context;
        this.enterScope();
    }

    public static GeneratedObjectStore create(ModelContext<?> context) {
        return context.getSelectorMaps().hasAssignments() ? new GeneratedObjectStore(context) : new NoopGeneratedObjectStore();
    }

    public boolean hasNewValues() {
        boolean tmp = this.hasNewValues;
        this.hasNewValues = false;
        return tmp;
    }

    public void enterScope() {
        Object scope = new Object();
        this.scopes.addLast(scope);
    }

    public void exitScope() {
        Object scope = this.scopes.removeLast();
        this.objectStore.remove(scope);
    }

    @Override
    public void objectCreated(InternalNode node, GeneratorResult result) {
        for (TargetSelector destination : this.context.getAssignmentDestinationSelectors(node)) {
            this.putValue(destination, result);
            LOG.trace("Added {} for {}", (Object)result, (Object)destination);
        }
    }

    public GeneratorResult getValue(TargetSelector destination) {
        Iterator<Object> iter = this.scopes.descendingIterator();
        while (iter.hasNext()) {
            GeneratorResult result;
            Object scope = iter.next();
            Map<TargetSelector, GeneratorResult> destinationValues = this.objectStore.get(scope);
            if (destinationValues == null || (result = destinationValues.get(destination)) == null) continue;
            return result;
        }
        return null;
    }

    private void putValue(TargetSelector selector, GeneratorResult generatedValue) {
        Object scope = this.scopes.peekLast();
        Map destinationValues = this.objectStore.computeIfAbsent(scope, k -> new IdentityHashMap());
        destinationValues.put(selector, generatedValue);
        this.hasNewValues = true;
    }

    @VisibleForTesting
    static final class NoopGeneratedObjectStore
    extends GeneratedObjectStore {
        NoopGeneratedObjectStore() {
            super(null);
        }

        @Override
        public boolean hasNewValues() {
            return false;
        }

        @Override
        public void enterScope() {
        }

        @Override
        public void exitScope() {
        }

        @Override
        public void objectCreated(InternalNode node, GeneratorResult result) {
        }

        @Override
        public GeneratorResult getValue(TargetSelector destination) {
            return EMPTY_RESULT;
        }
    }
}

