/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generation;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.instancio.generator.Generator;
import org.instancio.internal.assignment.InternalAssignment;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.generation.GeneratedObjectStore;
import org.instancio.internal.generation.NodeHandler;
import org.instancio.internal.generation.UserSuppliedGeneratorProcessor;
import org.instancio.internal.generator.GeneratorResult;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.Constants;
import org.instancio.internal.util.Fail;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AssignmentNodeHandler
implements NodeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AssignmentNodeHandler.class);
    private final ModelContext<?> context;
    private final GeneratedObjectStore generatedObjectStore;
    private final UserSuppliedGeneratorProcessor userSuppliedGeneratorProcessor;
    private final Set<InternalAssignment> unresolvedAssignments = new LinkedHashSet<InternalAssignment>();

    private AssignmentNodeHandler(ModelContext<?> context, GeneratedObjectStore generatedObjectStore, UserSuppliedGeneratorProcessor userSuppliedGeneratorProcessor) {
        this.context = context;
        this.generatedObjectStore = generatedObjectStore;
        this.userSuppliedGeneratorProcessor = userSuppliedGeneratorProcessor;
    }

    static AssignmentNodeHandler create(ModelContext<?> context, GeneratedObjectStore generatedObjectStore, UserSuppliedGeneratorProcessor userSuppliedGeneratorProcessor) {
        return context.getSelectorMaps().hasAssignments() ? new AssignmentNodeHandler(context, generatedObjectStore, userSuppliedGeneratorProcessor) : new NoopAssignmentNodeHandler();
    }

    @Override
    @NotNull
    public GeneratorResult getResult(@NotNull InternalNode node) {
        List<InternalAssignment> assignments = this.context.getAssignments(node);
        for (int i = assignments.size() - 1; i >= 0; --i) {
            InternalAssignment assignment = assignments.get(i);
            Predicate<Object> predicate = assignment.getOriginPredicate();
            if (predicate == null && assignment.getGenerator() != null) {
                Generator generator = assignment.getGenerator();
                return this.userSuppliedGeneratorProcessor.getGeneratorResult(node, generator);
            }
            GeneratorResult candidateResult = this.generatedObjectStore.getValue(assignment.getDestination());
            if (candidateResult == null) {
                LOG.trace("Delayed result for {}", (Object)assignment.getDestination());
                this.unresolvedAssignments.add(assignment);
                return GeneratorResult.delayed();
            }
            this.unresolvedAssignments.remove(assignment);
            LOG.trace("Value for destination {}: {}", (Object)assignment.getDestination(), candidateResult.getValue());
            if (predicate != null && !AssignmentNodeHandler.isSatisfied(candidateResult.getValue(), predicate)) continue;
            if (assignment.getGenerator() == null) {
                Object destinationResult = candidateResult.getValue();
                if (assignment.getValueMapper() != null) {
                    destinationResult = assignment.getValueMapper().apply(destinationResult);
                }
                return GeneratorResult.create(destinationResult, Constants.DO_NOT_MODIFY_HINT);
            }
            Generator generator = assignment.getGenerator();
            return this.userSuppliedGeneratorProcessor.getGeneratorResult(node, generator);
        }
        return GeneratorResult.emptyResult();
    }

    Set<InternalAssignment> getUnresolvedAssignments() {
        return this.unresolvedAssignments;
    }

    private static boolean isSatisfied(Object object, Predicate<Object> predicate) {
        try {
            return predicate.test(object);
        }
        catch (ClassCastException ex) {
            throw Fail.withUsageError("error invoking the predicate against generated object of type %s", object.getClass().getTypeName(), ex);
        }
        catch (Exception ex) {
            throw Fail.withUsageError("error invoking the predicate", ex);
        }
    }

    @VisibleForTesting
    static final class NoopAssignmentNodeHandler
    extends AssignmentNodeHandler {
        private NoopAssignmentNodeHandler() {
            super(null, null, null);
        }

        @Override
        @NotNull
        public GeneratorResult getResult(@NotNull InternalNode node) {
            return GeneratorResult.emptyResult();
        }

        @Override
        Set<InternalAssignment> getUnresolvedAssignments() {
            return Collections.emptySet();
        }
    }
}

