/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.assigners;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.instancio.exception.InstancioApiException;
import org.instancio.exception.InstancioException;
import org.instancio.internal.assigners.Assigner;
import org.instancio.internal.assigners.FieldAssigner;
import org.instancio.internal.assigners.SetterMethodResolverFacade;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.ErrorMessageUtils;
import org.instancio.internal.util.ExceptionUtils;
import org.instancio.internal.util.Format;
import org.instancio.internal.util.MethodUtils;
import org.instancio.internal.util.ReflectionUtils;
import org.instancio.settings.AssignmentType;
import org.instancio.settings.Keys;
import org.instancio.settings.OnSetMethodError;
import org.instancio.settings.OnSetMethodNotFound;
import org.instancio.settings.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MethodAssigner
implements Assigner {
    private static final Logger LOG = LoggerFactory.getLogger(MethodAssigner.class);
    private final Settings settings;
    private final int excludedModifiers;
    private final Assigner fieldAssigner;
    private final SetterMethodResolverFacade setterMethodResolverFacade;

    MethodAssigner(ModelContext<?> context) {
        this.settings = context.getSettings();
        this.excludedModifiers = this.settings.get(Keys.SETTER_EXCLUDE_MODIFIER);
        this.fieldAssigner = new FieldAssigner(this.settings);
        this.setterMethodResolverFacade = new SetterMethodResolverFacade(context.getServiceProviders().getSetterMethodResolvers());
        LOG.trace("{}, {}, {}, {}", new Object[]{AssignmentType.METHOD, this.settings.get(Keys.SETTER_STYLE), this.settings.get(Keys.ON_SET_METHOD_NOT_FOUND), this.settings.get(Keys.ON_SET_METHOD_ERROR)});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void assign(InternalNode node, Object target, Object arg) {
        Method method = this.getSetterMethod(node);
        if (method != null) {
            if (MethodUtils.isExcluded(method.getModifiers(), this.excludedModifiers)) {
                return;
            }
            try {
                if (arg == null && method.getParameterTypes()[0].isPrimitive()) return;
                ReflectionUtils.setAccessible(method);
                method.invoke(target, arg);
                return;
            }
            catch (IllegalAccessException ex) {
                throw new InstancioException("Error setting value via method: " + method, ex);
            }
            catch (Exception ex) {
                this.handleMethodInvocationError(node, target, arg, method, ex);
                return;
            }
        } else {
            this.handleMethodNotFoundError(node, target, arg);
        }
    }

    private Method getSetterMethod(InternalNode node) {
        Method method = this.setterMethodResolverFacade.resolveSetterMethod(node);
        return method == null ? node.getSetter() : method;
    }

    private void handleMethodInvocationError(InternalNode node, Object target, Object arg, Method method, Exception ex) {
        OnSetMethodError onSetMethodError = this.settings.get(Keys.ON_SET_METHOD_ERROR);
        if (onSetMethodError == OnSetMethodError.FAIL) {
            String methodName = Format.formatSetterMethod(method);
            String errorMsg = ErrorMessageUtils.getSetterInvocationErrorMessage(arg, methodName, ex, this.settings);
            throw new InstancioApiException(errorMsg, ex);
        }
        if (onSetMethodError == OnSetMethodError.ASSIGN_FIELD) {
            ExceptionUtils.logException("Error invoking method {}, assigning value using field: {}", ex, method, node.getField());
            this.fieldAssigner.assign(node, target, arg);
        } else if (onSetMethodError == OnSetMethodError.IGNORE) {
            ExceptionUtils.logException("{}: error invoking method: {}", ex, new Object[]{OnSetMethodError.IGNORE, method});
        }
    }

    private void handleMethodNotFoundError(InternalNode node, Object target, Object arg) {
        OnSetMethodNotFound onSetMethodNotFound = this.settings.get(Keys.ON_SET_METHOD_NOT_FOUND);
        if (onSetMethodNotFound == OnSetMethodNotFound.ASSIGN_FIELD) {
            LOG.trace("Could not resolve setter method, assigning value using field: {}", (Object)node.getField());
            this.fieldAssigner.assign(node, target, arg);
            return;
        }
        if (Modifier.isFinal(node.getField().getModifiers())) {
            return;
        }
        if (onSetMethodNotFound == OnSetMethodNotFound.FAIL) {
            throw new InstancioApiException(ErrorMessageUtils.setterNotFound(node, this.settings));
        }
        if (onSetMethodNotFound == OnSetMethodNotFound.IGNORE) {
            LOG.debug("{}: could not resolve setter method for field: {}", (Object)OnSetMethodNotFound.IGNORE, (Object)node.getField());
        }
    }
}

