/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.annotation;

import jakarta.validation.constraints.AssertFalse;
import jakarta.validation.constraints.AssertTrue;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Future;
import jakarta.validation.constraints.FutureOrPresent;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Negative;
import jakarta.validation.constraints.NegativeOrZero;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Past;
import jakarta.validation.constraints.PastOrPresent;
import jakarta.validation.constraints.Positive;
import jakarta.validation.constraints.PositiveOrZero;
import jakarta.validation.constraints.Size;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import org.instancio.internal.annotation.AnnotationHandlerMap;
import org.instancio.internal.annotation.CommonBeanValidationHandlerMap;

final class JakartaBeanValidationHandlerMap
extends CommonBeanValidationHandlerMap {
    JakartaBeanValidationHandlerMap() {
        this.put(() -> AssertFalse.class, new CommonBeanValidationHandlerMap.AssertBooleanHandler(false));
        this.put(() -> AssertTrue.class, new CommonBeanValidationHandlerMap.AssertBooleanHandler(true));
        this.put(() -> DecimalMax.class, new DecimalMaxHandler());
        this.put(() -> DecimalMin.class, new DecimalMinHandler());
        this.put(() -> Digits.class, new DigitsHandler());
        this.put(() -> Future.class, new CommonBeanValidationHandlerMap.FutureHandler());
        this.put(() -> FutureOrPresent.class, new CommonBeanValidationHandlerMap.FutureHandler());
        this.put(() -> Max.class, new MaxHandler());
        this.put(() -> Min.class, new MinHandler());
        this.put(() -> Negative.class, new CommonBeanValidationHandlerMap.NegativeHandler(new BigDecimal("-0.5")));
        this.put(() -> NotBlank.class, new CommonBeanValidationHandlerMap.NotEmptyHandler());
        this.put(() -> NotEmpty.class, new CommonBeanValidationHandlerMap.NotEmptyHandler());
        this.put(() -> NotNull.class, new CommonBeanValidationHandlerMap.NotNullHandler());
        this.put(() -> NegativeOrZero.class, new CommonBeanValidationHandlerMap.NegativeHandler(BigDecimal.ZERO));
        this.put(() -> Past.class, new CommonBeanValidationHandlerMap.PastHandler());
        this.put(() -> PastOrPresent.class, new CommonBeanValidationHandlerMap.PastHandler());
        this.put(() -> Positive.class, new CommonBeanValidationHandlerMap.PositiveHandler(new BigDecimal("0.5")));
        this.put(() -> PositiveOrZero.class, new CommonBeanValidationHandlerMap.PositiveHandler(BigDecimal.ZERO));
        this.put(() -> Size.class, new SizeHandler());
    }

    static AnnotationHandlerMap getInstance() {
        return Holder.INSTANCE;
    }

    private static final class DecimalMaxHandler
    extends CommonBeanValidationHandlerMap.AbstractDecimalMaxHandler {
        private DecimalMaxHandler() {
        }

        @Override
        String getValue(Annotation annotation) {
            return ((DecimalMax)annotation).value();
        }
    }

    private static final class DecimalMinHandler
    extends CommonBeanValidationHandlerMap.AbstractDecimalMinHandler {
        private DecimalMinHandler() {
        }

        @Override
        String getValue(Annotation annotation) {
            return ((DecimalMin)annotation).value();
        }
    }

    private static final class DigitsHandler
    extends CommonBeanValidationHandlerMap.AbstractDigitsHandler {
        private DigitsHandler() {
        }

        @Override
        int getFraction(Annotation annotation) {
            return ((Digits)annotation).fraction();
        }

        @Override
        int getInteger(Annotation annotation) {
            return ((Digits)annotation).integer();
        }
    }

    private static final class MaxHandler
    extends CommonBeanValidationHandlerMap.AbstractMaxHandler {
        private MaxHandler() {
        }

        @Override
        long getValue(Annotation annotation) {
            return ((Max)annotation).value();
        }
    }

    private static final class MinHandler
    extends CommonBeanValidationHandlerMap.AbstractMinHandler {
        private MinHandler() {
        }

        @Override
        long getValue(Annotation annotation) {
            return ((Min)annotation).value();
        }
    }

    private static final class SizeHandler
    extends CommonBeanValidationHandlerMap.AbstractSizeHandler {
        private SizeHandler() {
        }

        @Override
        int getMin(Annotation annotation) {
            return ((Size)annotation).min();
        }

        @Override
        int getMax(Annotation annotation) {
            return ((Size)annotation).max();
        }
    }

    private static final class Holder {
        private static final AnnotationHandlerMap INSTANCE = new JakartaBeanValidationHandlerMap();

        private Holder() {
        }
    }
}

