/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.instancio.TargetSelector;
import org.instancio.internal.ApiMethodSelector;
import org.instancio.internal.InternalModel;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.nodes.NodeStats;
import org.instancio.internal.util.Constants;
import org.instancio.internal.util.Format;

final class InternalModelDump {
    private final Consumer<String> consumer;

    private InternalModelDump(Consumer<String> consumer) {
        this.consumer = consumer;
    }

    static void printVerbose(InternalModel<?> model) {
        InternalModelDump modelDump = new InternalModelDump(System.out::println);
        modelDump.consume(model);
    }

    void consume(InternalModel<?> model) {
        if (model.getModelContext().isVerbose()) {
            String modelDump = InternalModelDump.createModelDump(model);
            this.consumer.accept(modelDump);
        }
    }

    private static String createModelDump(InternalModel<?> model) {
        ModelContext<?> context = model.getModelContext();
        InternalNode rootNode = model.getRootNode();
        NodeStats nodeStats = NodeStats.compute(rootNode);
        String location = Format.firstNonInstancioStackTraceLine(new Throwable());
        StringBuilder sb = new StringBuilder(10000).append(" _____              _                       _          __  __             _        _").append(Constants.NL).append("|_   _|            | |                     (_)        |  \\/  |           | |      | |").append(Constants.NL).append("  | |   _ __   ___ | |_  __ _  _ __    ___  _   ___   | \\  / |  ___    __| |  ___ | |").append(Constants.NL).append("  | |  | '_ \\ / __|| __|/ _` || '_ \\  / __|| | / _ \\  | |\\/| | / _ \\  / _` | / _ \\| |").append(Constants.NL).append(" _| |_ | | | |\\__ \\| |_| (_| || | | || (__ | || (_) | | |  | || (_) || (_| ||  __/| |").append(Constants.NL).append("|_____||_| |_||___/ \\__|\\__,_||_| |_| \\___||_| \\___/  |_|  |_| \\___/  \\__,_| \\___||_|").append(Constants.NL).append("________________________________________________________________________________________").append(Constants.NL).append(Constants.NL).append(" -> Instancio model for ").append(Format.withoutPackage(rootNode.getType())).append(Constants.NL).append("    at ").append(location).append(Constants.NL).append(Constants.NL).append("### Settings").append(Constants.NL).append(Constants.NL).append(context.getSettings()).append(Constants.NL).append(Constants.NL).append("### Nodes").append(Constants.NL).append(Constants.NL).append("Format: <depth:class: field>").append(Constants.NL).append(Constants.NL).append(nodeStats.getTreeString()).append(Constants.NL).append(" -> Node max depth ........: ").append(nodeStats.getHeight()).append(Constants.NL).append(" -> Model max depth .......: ").append(context.getMaxDepth()).append(Constants.NL).append(" -> Total nodes ...........: ").append(nodeStats.getTotalNodes()).append(Constants.NL).append(" -> Seed ..................: ").append(context.getRandom().getSeed()).append(Constants.NL).append(Constants.NL);
        InternalModelDump.appendSelectorMatches(sb, model);
        return sb.append("________________________________________________________________________________________").append(Constants.NL).append("Done. Reminder to remove verbose() from:").append(Constants.NL).append(location).append(Constants.NL).toString();
    }

    private static void appendSelectorMatches(StringBuilder sb, InternalModel<?> model) {
        InternalNode rootNode = model.getRootNode();
        ModelContext<?> context = model.getModelContext();
        Map<ApiMethodSelector, Map<TargetSelector, Set<InternalNode>>> map = context.getSelectors(rootNode);
        sb.append("### Selectors").append(Constants.NL).append(Constants.NL).append("Selectors and matching nodes, if any:").append(Constants.NL).append(Constants.NL);
        for (Map.Entry<ApiMethodSelector, Map<TargetSelector, Set<InternalNode>>> entry : map.entrySet()) {
            Map<TargetSelector, Set<InternalNode>> selectorNodes = entry.getValue();
            if (selectorNodes.isEmpty()) continue;
            ApiMethodSelector method = entry.getKey();
            sb.append(" -> Method: ").append(method.getDescription()).append(Constants.NL);
            selectorNodes.forEach((selector, nodes) -> {
                sb.append("    - ").append(selector).append(Constants.NL);
                nodes.forEach(node -> sb.append("       \\_ ").append(node).append(Constants.NL));
                sb.append(Constants.NL);
            });
        }
    }
}

