/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.util;

import java.lang.reflect.Field;
import org.instancio.generator.GeneratorSpec;
import org.instancio.generator.specs.NumberGeneratorSpec;
import org.instancio.internal.generator.lang.AbstractRandomNumberGeneratorSpec;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.Range;

public final class BeanValidationUtils {
    private BeanValidationUtils() {
    }

    public static Range<Integer> calculateRange(int min, int max, int maxLimit) {
        int maxSize;
        int minSize;
        if (min > max) {
            throw Fail.withUsageError(String.format("invalid bean validation annotation: min must be less than or equal to max: min=%s, max=%s", min, max), new Object[0]);
        }
        if (max == 0) {
            minSize = 0;
            maxSize = 0;
        } else if (min <= 1) {
            minSize = 1;
            maxSize = Math.min(max, maxLimit);
        } else if (BeanValidationUtils.isMoreThanDouble(min, max)) {
            int tmpMax = min * 150 / 100;
            minSize = min;
            maxSize = Math.min(max, tmpMax);
        } else {
            minSize = min;
            maxSize = max;
        }
        return Range.of(minSize, maxSize);
    }

    private static boolean isMoreThanDouble(int min, int max) {
        return max - min - min > 0;
    }

    public static void setNonNullablePrimitive(GeneratorSpec<?> spec, Field field) {
        if (spec instanceof NumberGeneratorSpec && field.getType().isPrimitive()) {
            ((AbstractRandomNumberGeneratorSpec)spec).nullable(false);
        }
    }
}

