/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.generator.array;

import org.instancio.Random;
import org.instancio.generator.AfterGenerate;
import org.instancio.generator.GeneratorContext;
import org.instancio.generator.Hints;
import org.instancio.generator.specs.OneOfArraySpec;
import org.instancio.internal.ApiValidator;
import org.instancio.internal.generator.AbstractGenerator;
import org.instancio.internal.generator.InternalGeneratorHint;
import org.instancio.support.Global;

public class OneOfArrayGenerator<T>
extends AbstractGenerator<T>
implements OneOfArraySpec<T> {
    private T[] values;

    public OneOfArrayGenerator() {
        this(Global.generatorContext());
    }

    public OneOfArrayGenerator(GeneratorContext context) {
        super(context);
    }

    @Override
    public String apiMethod() {
        return null;
    }

    @Override
    public OneOfArrayGenerator<T> oneOf(T ... values) {
        this.values = ApiValidator.notEmpty(values, "Array must have at least one element", new Object[0]);
        return this;
    }

    @Override
    public OneOfArrayGenerator<T> nullable() {
        super.nullable();
        return this;
    }

    @Override
    protected T tryGenerateNonNull(Random random) {
        return random.oneOf(this.values);
    }

    @Override
    public Hints hints() {
        return Hints.builder().afterGenerate(AfterGenerate.POPULATE_ALL).with(InternalGeneratorHint.builder().targetClass(this.values.getClass().getComponentType()).build()).build();
    }
}

