/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.assigners;

import java.lang.reflect.Field;
import org.instancio.assignment.AssignmentType;
import org.instancio.assignment.OnSetFieldError;
import org.instancio.exception.InstancioApiException;
import org.instancio.internal.assigners.Assigner;
import org.instancio.internal.assigners.AssignerErrorUtil;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.ExceptionHandler;
import org.instancio.internal.util.Fail;
import org.instancio.settings.Keys;
import org.instancio.settings.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FieldAssigner
implements Assigner {
    private static final Logger LOG = LoggerFactory.getLogger(FieldAssigner.class);
    private final Settings settings;

    FieldAssigner(Settings settings) {
        this.settings = settings;
        LOG.trace("{}, {}", (Object)AssignmentType.FIELD, (Object)settings.get(Keys.ON_SET_FIELD_ERROR));
    }

    @Override
    public void assign(InternalNode node, Object target, Object value) {
        Field field = node.getField();
        if (value != null) {
            this.setField(target, field, value);
        } else if (!field.getType().isPrimitive()) {
            this.setField(target, field, null);
        }
    }

    private void setField(Object target, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (IllegalArgumentException ex) {
            String msg = AssignerErrorUtil.getIncompatibleTypesErrorMessage(value, field, ex);
            throw Fail.withUsageError(msg, ex);
        }
        catch (Exception ex) {
            this.handleError(field, value, ex);
        }
    }

    private void handleError(Field field, Object value, Exception ex) {
        OnSetFieldError onSetFieldError = this.settings.get(Keys.ON_SET_FIELD_ERROR);
        if (onSetFieldError == OnSetFieldError.FAIL) {
            String msg = AssignerErrorUtil.incompatibleField(value, field, ex, this.settings);
            throw new InstancioApiException(msg, ex);
        }
        if (onSetFieldError == OnSetFieldError.IGNORE) {
            ExceptionHandler.logException("{}: error assigning value to field: {}", ex, new Object[]{OnSetFieldError.IGNORE, field});
        }
    }
}

