/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal.assigners;

import org.instancio.assignment.AssignmentType;
import org.instancio.internal.assigners.Assigner;
import org.instancio.internal.assigners.FieldAssigner;
import org.instancio.internal.assigners.MethodAssigner;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.util.Fail;
import org.instancio.internal.util.ObjectUtils;
import org.instancio.internal.util.SystemProperties;
import org.instancio.settings.Keys;
import org.instancio.settings.Settings;

public class AssignerImpl
implements Assigner {
    private final Assigner delegate;

    public AssignerImpl(ModelContext<?> context) {
        this.delegate = AssignerImpl.resolveAssigner(context);
    }

    @Override
    public void assign(InternalNode node, Object target, Object value) {
        this.delegate.assign(node, target, value);
    }

    private static Assigner resolveAssigner(ModelContext<?> context) {
        Settings settings = context.getSettings();
        AssignmentType defaultAssignment = settings.get(Keys.ASSIGNMENT_TYPE);
        AssignmentType assignment = ObjectUtils.defaultIfNull(SystemProperties.getAssignmentType(), defaultAssignment);
        if (assignment == AssignmentType.FIELD) {
            return new FieldAssigner(settings);
        }
        if (assignment == AssignmentType.METHOD) {
            return new MethodAssigner(settings);
        }
        throw Fail.withFataInternalError("Invalid assignment type: %s", new Object[]{assignment});
    }
}

