/*
 * Decompiled with CFR 0.152.
 */
package org.instancio.internal;

import org.instancio.Model;
import org.instancio.internal.context.ModelContext;
import org.instancio.internal.nodes.InternalNode;
import org.instancio.internal.nodes.NodeContext;
import org.instancio.internal.nodes.NodeFactory;

final class InternalModel<T>
implements Model<T> {
    private final ModelContext<T> modelContext;
    private final InternalNode rootNode;

    InternalModel(ModelContext<T> modelContext) {
        this.modelContext = modelContext;
        this.rootNode = this.createRootNode();
    }

    ModelContext<T> getModelContext() {
        return this.modelContext;
    }

    InternalNode getRootNode() {
        return this.rootNode;
    }

    private InternalNode createRootNode() {
        NodeContext nodeContext = NodeContext.builder().maxDepth(this.modelContext.getMaxDepth()).rootTypeMap(this.modelContext.getRootTypeMap()).ignoredSelectorMap(this.modelContext.getIgnoredSelectorMap()).subtypeSelectorMap(this.modelContext.getSubtypeSelectorMap()).subtypeMappingFromSettings(this.modelContext.getSettings().getSubtypeMap()).containerFactories(this.modelContext.getContainerFactories()).providerEntries(this.modelContext.getServiceProviders().getTypeResolvers()).build();
        NodeFactory nodeFactory = new NodeFactory(nodeContext);
        return nodeFactory.createRootNode(this.modelContext.getRootType());
    }

    public String toString() {
        return String.format("Model<%s>", this.rootNode.getType().getTypeName());
    }
}

