/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.inboundhandler;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.remote.CacheRpcCommand;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.remoting.inboundhandler.BaseBlockingRunnable;
import org.infinispan.remoting.inboundhandler.BasePerCacheInboundInvocationHandler;
import org.infinispan.remoting.inboundhandler.Reply;
import org.infinispan.remoting.inboundhandler.TopologyMode;
import org.infinispan.remoting.responses.CacheNotFoundResponse;

public class DefaultTopologyRunnable
extends BaseBlockingRunnable {
    private final TopologyMode topologyMode;
    protected final int commandTopologyId;

    public DefaultTopologyRunnable(BasePerCacheInboundInvocationHandler handler, CacheRpcCommand command, Reply reply, TopologyMode topologyMode, int commandTopologyId, boolean sync) {
        super(handler, command, reply, sync);
        this.topologyMode = topologyMode;
        this.commandTopologyId = commandTopologyId;
    }

    @Override
    public boolean isReady() {
        return switch (this.topologyMode) {
            case TopologyMode.READY_TOPOLOGY -> this.handler.getStateTransferLock().topologyReceived(this.waitTopology());
            case TopologyMode.READY_TX_DATA -> this.handler.getStateTransferLock().transactionDataReceived(this.waitTopology());
            default -> true;
        };
    }

    @Override
    protected CompletionStage<CacheNotFoundResponse> beforeInvoke() {
        CompletionStage<Void> stage = null;
        switch (this.topologyMode) {
            case WAIT_TOPOLOGY: {
                stage = this.handler.getStateTransferLock().topologyFuture(this.waitTopology());
                break;
            }
            case WAIT_TX_DATA: {
                stage = this.handler.getStateTransferLock().transactionDataFuture(this.waitTopology());
                break;
            }
        }
        if (stage != null && !CompletionStages.isCompletedSuccessfully(stage)) {
            return stage.thenApply(nil -> this.handler.isCommandSentBeforeFirstTopology(this.commandTopologyId) ? CacheNotFoundResponse.INSTANCE : null);
        }
        return this.handler.isCommandSentBeforeFirstTopology(this.commandTopologyId) ? CompletableFuture.completedFuture(CacheNotFoundResponse.INSTANCE) : null;
    }

    private int waitTopology() {
        return Math.max(this.commandTopologyId, 0);
    }

    @Override
    public String toString() {
        return "DefaultTopologyRunnable{topologyMode=" + String.valueOf((Object)this.topologyMode) + ", commandTopologyId=" + this.commandTopologyId + ", command=" + String.valueOf(this.command) + ", sync=" + this.sync + "}";
    }
}

