/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.container.versioning.irac.DefaultIracTombstoneManager;
import org.infinispan.container.versioning.irac.IracTombstoneManager;
import org.infinispan.container.versioning.irac.NoOpIracTombstoneManager;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.util.logging.Log;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.irac.DefaultIracManager;
import org.infinispan.xsite.irac.IracManager;
import org.infinispan.xsite.irac.IracXSiteBackup;
import org.infinispan.xsite.irac.NoOpIracManager;

@DefaultFactoryFor(classes={IracManager.class, IracTombstoneManager.class})
public class IracComponentFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Inject
    Transport transport;
    @GuardedBy(value="this")
    private List<IracXSiteBackup> asyncBackups;

    @Override
    public Object construct(String name) {
        if (name.equals(IracTombstoneManager.class.getName())) {
            List<IracXSiteBackup> backups = this.getAsyncBackups();
            return backups.isEmpty() ? NoOpIracTombstoneManager.getInstance() : new DefaultIracTombstoneManager(this.configuration, backups);
        }
        if (name.equals(IracManager.class.getName())) {
            List<IracXSiteBackup> backups = this.getAsyncBackups();
            return backups.isEmpty() ? NoOpIracManager.INSTANCE : new DefaultIracManager(this.configuration, backups);
        }
        throw Log.CONTAINER.factoryCannotConstructComponent(name);
    }

    private synchronized List<IracXSiteBackup> getAsyncBackups() {
        if (this.asyncBackups != null) {
            return this.asyncBackups;
        }
        if (this.transport == null) {
            this.asyncBackups = Collections.emptyList();
            return this.asyncBackups;
        }
        AtomicInteger index = new AtomicInteger(-1);
        this.asyncBackups = this.configuration.sites().asyncBackupsStream().filter(this::isRemoteSite).map(c -> this.create((BackupConfiguration)((Object)c), index)).collect(Collectors.toList());
        if (log.isTraceEnabled()) {
            String b = this.asyncBackups.stream().map(XSiteBackup::getSiteName).collect(Collectors.joining(", "));
            log.tracef("Async remote sites found: %s", b);
        }
        if (!this.asyncBackups.isEmpty()) {
            this.transport.checkCrossSiteAvailable();
        }
        return this.asyncBackups;
    }

    private boolean isRemoteSite(BackupConfiguration config) {
        return !config.site().equals(this.transport.localSiteName());
    }

    private IracXSiteBackup create(BackupConfiguration config, AtomicInteger index) {
        return new IracXSiteBackup(config.site(), true, config.replicationTimeout(), config.backupFailurePolicy() == BackupFailurePolicy.WARN, (short)index.incrementAndGet());
    }
}

