/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import org.infinispan.commons.marshall.WrappedBytes;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.AbstractDelegatingInternalDataContainer;
import org.infinispan.container.impl.AbstractInternalDataContainer;
import org.infinispan.container.impl.DefaultSegmentedDataContainer;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.container.impl.PeekableTouchableMap;
import org.infinispan.container.offheap.OffHeapConcurrentMap;
import org.infinispan.container.offheap.OffHeapEntryFactory;
import org.infinispan.container.offheap.OffHeapLruNode;
import org.infinispan.container.offheap.OffHeapMemoryAllocator;
import org.infinispan.container.offheap.UnpooledOffHeapMemoryAllocator;
import org.infinispan.eviction.EvictionManager;
import org.infinispan.eviction.impl.PassivationManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.util.concurrent.DataOperationOrderer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NAMED_CACHE)
public class SegmentedBoundedOffHeapDataContainer
extends AbstractDelegatingInternalDataContainer<WrappedBytes, WrappedBytes> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final OffHeapListener offHeapListener;
    @Inject
    ComponentRegistry componentRegistry;
    @Inject
    protected OffHeapMemoryAllocator allocator;
    @Inject
    protected OffHeapEntryFactory offHeapEntryFactory;
    @Inject
    protected EvictionManager evictionManager;
    @Inject
    protected ComponentRef<PassivationManager> passivator;
    @Inject
    protected DataOperationOrderer orderer;
    @Inject
    @ComponentName(value="org.infinispan.executors.non-blocking")
    Executor nonBlockingExecutor;
    protected final long maxSize;
    protected final Lock lruLock;
    protected final boolean useCount;
    protected final int numSegments;
    protected volatile long currentSize;
    protected long firstAddress;
    protected long lastAddress;
    protected DefaultSegmentedDataContainer dataContainer;

    public SegmentedBoundedOffHeapDataContainer(int numSegments, long maxSize, boolean memoryBounded) {
        this.numSegments = numSegments;
        this.offHeapListener = new OffHeapListener();
        this.maxSize = maxSize;
        this.useCount = !memoryBounded;
        OffHeapMapSupplier offHeapMapSupplier = new OffHeapMapSupplier();
        this.lruLock = new ReentrantLock();
        this.firstAddress = 0L;
        this.dataContainer = new DefaultSegmentedDataContainer<WrappedBytes, WrappedBytes>(offHeapMapSupplier, numSegments);
    }

    @Start
    public void start() {
        this.dataContainer.start();
    }

    @Stop
    public void stop() {
        this.dataContainer.stop();
    }

    @Override
    protected InternalDataContainer<WrappedBytes, WrappedBytes> delegate() {
        return this.dataContainer;
    }

    @Override
    public void put(WrappedBytes key, WrappedBytes value, Metadata metadata) {
        super.put(key, value, metadata);
        this.ensureSize();
    }

    @Override
    public void put(int segment, WrappedBytes key, WrappedBytes value, Metadata metadata, PrivateMetadata internalMetadata, long createdTimestamp, long lastUseTimestamp) {
        super.put(segment, key, value, metadata, internalMetadata, createdTimestamp, lastUseTimestamp);
        this.ensureSize();
    }

    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> compute(WrappedBytes key, DataContainer.ComputeAction<WrappedBytes, WrappedBytes> action) {
        InternalCacheEntry<WrappedBytes, WrappedBytes> result = super.compute(key, action);
        if (result != null) {
            this.ensureSize();
        }
        return result;
    }

    @Override
    public InternalCacheEntry<WrappedBytes, WrappedBytes> compute(int segment, WrappedBytes key, DataContainer.ComputeAction<WrappedBytes, WrappedBytes> action) {
        InternalCacheEntry<WrappedBytes, WrappedBytes> result = super.compute(segment, key, action);
        if (result != null) {
            this.ensureSize();
        }
        return result;
    }

    protected OffHeapConcurrentMap getMapThatContainsKey(byte[] key) {
        int segment = this.dataContainer.getSegmentForKey(key);
        return (OffHeapConcurrentMap)this.dataContainer.getMapForSegment(segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void ensureSize() {
        if (this.currentSize <= this.maxSize) {
            return;
        }
        while (true) {
            long addressToRemove;
            long writeStamp;
            StampedLock stampedLock;
            OffHeapConcurrentMap map;
            byte[] key;
            this.lruLock.lock();
            try {
                if (this.currentSize <= this.maxSize) return;
                assert (this.firstAddress > 0L);
                key = this.offHeapEntryFactory.getKey(this.firstAddress);
                map = this.getMapThatContainsKey(key);
                if (map == null) continue;
                int hashCode = this.offHeapEntryFactory.getHashCode(this.firstAddress);
                stampedLock = map.getStampedLock(hashCode);
                writeStamp = stampedLock.tryWriteLock();
                addressToRemove = writeStamp != 0L ? this.firstAddress : 0L;
            }
            finally {
                this.lruLock.unlock();
                continue;
            }
            if (addressToRemove == 0L) {
                writeStamp = stampedLock.writeLock();
                try {
                    this.lruLock.lock();
                    try {
                        int hashCode;
                        StampedLock innerLock;
                        if (this.currentSize <= this.maxSize) return;
                        key = this.offHeapEntryFactory.getKey(this.firstAddress);
                        OffHeapConcurrentMap protectedMap = this.getMapThatContainsKey(key);
                        if (protectedMap == map && (innerLock = map.getStampedLock(hashCode = this.offHeapEntryFactory.getHashCode(this.firstAddress))) == stampedLock) {
                            addressToRemove = this.firstAddress;
                        }
                    }
                    finally {
                        this.lruLock.unlock();
                    }
                }
                finally {
                    if (addressToRemove == 0L) {
                        stampedLock.unlockWrite(writeStamp);
                    }
                }
            }
            if (addressToRemove == 0L) continue;
            if (log.isTraceEnabled()) {
                log.tracef("Removing entry: 0x%016x due to eviction due to size %d being larger than maximum of %d", addressToRemove, this.currentSize, this.maxSize);
            }
            try {
                InternalCacheEntry<WrappedBytes, WrappedBytes> ice = this.offHeapEntryFactory.fromMemory(addressToRemove);
                map.remove((WrappedBytes)ice.getKey(), addressToRemove);
                AbstractInternalDataContainer.handleEviction(ice, this.orderer, this.passivator.running(), this.evictionManager, this, this.nonBlockingExecutor, null);
                continue;
            }
            finally {
                stampedLock.unlockWrite(writeStamp);
                continue;
            }
            break;
        }
    }

    public long getSize(long address) {
        if (this.useCount) {
            return 1L;
        }
        return this.offHeapEntryFactory.getSize(address, true);
    }

    @Override
    public long capacity() {
        return this.maxSize;
    }

    @Override
    public long evictionSize() {
        return this.currentSize;
    }

    private class OffHeapListener
    implements OffHeapConcurrentMap.EntryListener {
        private OffHeapListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean resize(int pointerCount) {
            if (SegmentedBoundedOffHeapDataContainer.this.useCount) {
                return true;
            }
            SegmentedBoundedOffHeapDataContainer.this.lruLock.lock();
            try {
                long changeSizeForAllSegments;
                boolean isNegative = pointerCount < 0;
                long memoryUsed = (long)Math.abs(pointerCount) << 3;
                long change = UnpooledOffHeapMemoryAllocator.estimateSizeOverhead(memoryUsed);
                if (!(isNegative || (changeSizeForAllSegments = change * (long)SegmentedBoundedOffHeapDataContainer.this.numSegments) >= 0L && changeSizeForAllSegments < SegmentedBoundedOffHeapDataContainer.this.maxSize)) {
                    boolean bl = false;
                    return bl;
                }
                SegmentedBoundedOffHeapDataContainer.this.currentSize = isNegative ? (SegmentedBoundedOffHeapDataContainer.this.currentSize -= change) : (SegmentedBoundedOffHeapDataContainer.this.currentSize += change);
            }
            finally {
                SegmentedBoundedOffHeapDataContainer.this.lruLock.unlock();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void entryCreated(long newAddress) {
            long newSize = SegmentedBoundedOffHeapDataContainer.this.getSize(newAddress);
            SegmentedBoundedOffHeapDataContainer.this.lruLock.lock();
            try {
                SegmentedBoundedOffHeapDataContainer.this.currentSize += newSize;
                this.addEntryAddressToEnd(newAddress);
            }
            finally {
                SegmentedBoundedOffHeapDataContainer.this.lruLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void entryRemoved(long removedAddress) {
            long removedSize = SegmentedBoundedOffHeapDataContainer.this.getSize(removedAddress);
            SegmentedBoundedOffHeapDataContainer.this.lruLock.lock();
            try {
                SegmentedBoundedOffHeapDataContainer.this.currentSize -= removedSize;
                this.removeNode(removedAddress);
            }
            finally {
                SegmentedBoundedOffHeapDataContainer.this.lruLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void entryReplaced(long newAddress, long oldAddress) {
            long oldSize = SegmentedBoundedOffHeapDataContainer.this.getSize(oldAddress);
            long newSize = SegmentedBoundedOffHeapDataContainer.this.getSize(newAddress);
            SegmentedBoundedOffHeapDataContainer.this.lruLock.lock();
            try {
                this.removeNode(oldAddress);
                this.addEntryAddressToEnd(newAddress);
                SegmentedBoundedOffHeapDataContainer.this.currentSize += newSize;
                SegmentedBoundedOffHeapDataContainer.this.currentSize -= oldSize;
            }
            finally {
                SegmentedBoundedOffHeapDataContainer.this.lruLock.unlock();
            }
        }

        @Override
        public void entryRetrieved(long entryAddress) {
            SegmentedBoundedOffHeapDataContainer.this.lruLock.lock();
            try {
                if (log.isTraceEnabled()) {
                    log.tracef("Moving entry 0x%016x to the end of the LRU list", entryAddress);
                }
                this.moveToEnd(entryAddress);
            }
            finally {
                SegmentedBoundedOffHeapDataContainer.this.lruLock.unlock();
            }
        }

        private void addEntryAddressToEnd(long entryAddress) {
            if (log.isTraceEnabled()) {
                log.tracef("Adding entry 0x%016x to the end of the LRU list", entryAddress);
            }
            if (SegmentedBoundedOffHeapDataContainer.this.lastAddress == 0L) {
                SegmentedBoundedOffHeapDataContainer.this.firstAddress = entryAddress;
                SegmentedBoundedOffHeapDataContainer.this.lastAddress = entryAddress;
                OffHeapLruNode.setPrevious(entryAddress, 0L);
            } else {
                OffHeapLruNode.setPrevious(entryAddress, SegmentedBoundedOffHeapDataContainer.this.lastAddress);
                OffHeapLruNode.setNext(SegmentedBoundedOffHeapDataContainer.this.lastAddress, entryAddress);
                SegmentedBoundedOffHeapDataContainer.this.lastAddress = entryAddress;
            }
            OffHeapLruNode.setNext(entryAddress, 0L);
        }

        private void removeNode(long address) {
            long previousLRUNode;
            boolean middleNode = true;
            if (address == SegmentedBoundedOffHeapDataContainer.this.lastAddress) {
                if (log.isTraceEnabled()) {
                    log.tracef("Removed entry 0x%016x from the end of the LRU list", address);
                }
                if ((previousLRUNode = OffHeapLruNode.getPrevious(address)) != 0L) {
                    OffHeapLruNode.setNext(previousLRUNode, 0L);
                }
                SegmentedBoundedOffHeapDataContainer.this.lastAddress = previousLRUNode;
                middleNode = false;
            }
            if (address == SegmentedBoundedOffHeapDataContainer.this.firstAddress) {
                long nextLRUNode;
                if (log.isTraceEnabled()) {
                    log.tracef("Removed entry 0x%016x from the beginning of the LRU list", address);
                }
                if ((nextLRUNode = OffHeapLruNode.getNext(address)) != 0L) {
                    OffHeapLruNode.setPrevious(nextLRUNode, 0L);
                }
                SegmentedBoundedOffHeapDataContainer.this.firstAddress = nextLRUNode;
                middleNode = false;
            }
            if (middleNode) {
                if (log.isTraceEnabled()) {
                    log.tracef("Removed entry 0x%016x from the middle of the LRU list", address);
                }
                previousLRUNode = OffHeapLruNode.getPrevious(address);
                long nextLRUNode = OffHeapLruNode.getNext(address);
                assert (previousLRUNode != 0L);
                assert (nextLRUNode != 0L);
                OffHeapLruNode.setNext(previousLRUNode, nextLRUNode);
                OffHeapLruNode.setPrevious(nextLRUNode, previousLRUNode);
            }
        }

        private void moveToEnd(long lruNode) {
            if (lruNode != SegmentedBoundedOffHeapDataContainer.this.lastAddress) {
                long nextLruNode = OffHeapLruNode.getNext(lruNode);
                assert (nextLruNode != 0L);
                if (lruNode == SegmentedBoundedOffHeapDataContainer.this.firstAddress) {
                    OffHeapLruNode.setPrevious(nextLruNode, 0L);
                    SegmentedBoundedOffHeapDataContainer.this.firstAddress = nextLruNode;
                } else {
                    long prevLruNode = OffHeapLruNode.getPrevious(lruNode);
                    assert (prevLruNode != 0L);
                    OffHeapLruNode.setNext(prevLruNode, nextLruNode);
                    OffHeapLruNode.setPrevious(nextLruNode, prevLruNode);
                }
                OffHeapLruNode.setNext(SegmentedBoundedOffHeapDataContainer.this.lastAddress, lruNode);
                OffHeapLruNode.setPrevious(lruNode, SegmentedBoundedOffHeapDataContainer.this.lastAddress);
                OffHeapLruNode.setNext(lruNode, 0L);
                SegmentedBoundedOffHeapDataContainer.this.lastAddress = lruNode;
            }
        }
    }

    private class OffHeapMapSupplier
    implements Supplier<PeekableTouchableMap<WrappedBytes, WrappedBytes>> {
        private OffHeapMapSupplier() {
        }

        @Override
        public PeekableTouchableMap<WrappedBytes, WrappedBytes> get() {
            return new OffHeapConcurrentMap(SegmentedBoundedOffHeapDataContainer.this.allocator, SegmentedBoundedOffHeapDataContainer.this.offHeapEntryFactory, SegmentedBoundedOffHeapDataContainer.this.offHeapListener);
        }
    }
}

