/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries.metadata;

import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.ImmortalCacheValue;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataAware;
import org.infinispan.container.entries.metadata.MetadataMortalCacheEntry;
import org.infinispan.marshall.protostream.impl.MarshallableObject;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;

@ProtoTypeId(value=1124)
public class MetadataMortalCacheValue
extends ImmortalCacheValue
implements MetadataAware {
    Metadata metadata;
    long created;

    public MetadataMortalCacheValue(Object value, Metadata metadata, long created) {
        this(value, null, metadata, created);
    }

    protected MetadataMortalCacheValue(Object value, PrivateMetadata internalMetadata, Metadata metadata, long created) {
        super(value, internalMetadata);
        this.metadata = metadata;
        this.created = created;
    }

    @ProtoFactory
    MetadataMortalCacheValue(MarshallableObject<?> wrappedValue, PrivateMetadata internalMetadata, MarshallableObject<Metadata> wrappedMetadata, long created) {
        super(wrappedValue, internalMetadata);
        this.metadata = MarshallableObject.unwrap(wrappedMetadata);
        this.created = created;
    }

    @ProtoField(number=3, name="metadata")
    public MarshallableObject<Metadata> getWrappedMetadata() {
        return MarshallableObject.create(this.metadata);
    }

    @Override
    @ProtoField(value=4)
    public final long getCreated() {
        return this.created;
    }

    @Override
    public InternalCacheEntry<?, ?> toInternalCacheEntry(Object key) {
        return new MetadataMortalCacheEntry(key, this.value, this.internalMetadata, this.metadata, this.created);
    }

    @Override
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public final long getLifespan() {
        return this.metadata.lifespan();
    }

    @Override
    public boolean isExpired(long now) {
        return ExpiryHelper.isExpiredMortal(this.metadata.lifespan(), this.created, now);
    }

    @Override
    public long getExpiryTime() {
        long lifespan = this.metadata.lifespan();
        return lifespan > -1L ? this.created + lifespan : -1L;
    }

    @Override
    public final boolean canExpire() {
        return true;
    }

    @Override
    protected void appendFieldsToString(StringBuilder builder) {
        super.appendFieldsToString(builder);
        builder.append(", metadata=").append(this.metadata);
        builder.append(", created=").append(this.created);
    }
}

