/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.Combine;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.util.TimeQuantity;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.configuration.cache.LockingConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;

public class LockingConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<LockingConfiguration> {
    private final AttributeSet attributes = LockingConfiguration.attributeDefinitionSet();

    protected LockingConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public LockingConfigurationBuilder concurrencyLevel(int i) {
        this.attributes.attribute(LockingConfiguration.CONCURRENCY_LEVEL).set((Object)i);
        return this;
    }

    public LockingConfigurationBuilder isolationLevel(IsolationLevel isolationLevel) {
        this.attributes.attribute(LockingConfiguration.ISOLATION_LEVEL).set((Object)isolationLevel);
        return this;
    }

    @Deprecated(forRemoval=true, since="15.0")
    public LockingConfigurationBuilder isolationLevel(org.infinispan.util.concurrent.IsolationLevel isolationLevel) {
        this.attributes.attribute(LockingConfiguration.ISOLATION_LEVEL).set((Object)isolationLevel.to());
        return this;
    }

    @Deprecated(forRemoval=true, since="15.0")
    public org.infinispan.util.concurrent.IsolationLevel isolationLevel() {
        return org.infinispan.util.concurrent.IsolationLevel.from((IsolationLevel)((Object)this.attributes.attribute(LockingConfiguration.ISOLATION_LEVEL).get()));
    }

    public LockingConfigurationBuilder lockAcquisitionTimeout(long l) {
        this.attributes.attribute(LockingConfiguration.LOCK_ACQUISITION_TIMEOUT).set((Object)TimeQuantity.valueOf((long)l));
        return this;
    }

    public LockingConfigurationBuilder lockAcquisitionTimeout(String s) {
        this.attributes.attribute(LockingConfiguration.LOCK_ACQUISITION_TIMEOUT).set((Object)TimeQuantity.valueOf((String)s));
        return this;
    }

    public LockingConfigurationBuilder lockAcquisitionTimeout(long l, TimeUnit unit) {
        return this.lockAcquisitionTimeout(unit.toMillis(l));
    }

    public LockingConfigurationBuilder useLockStriping(boolean b) {
        this.attributes.attribute(LockingConfiguration.USE_LOCK_STRIPING).set((Object)b);
        return this;
    }

    public void validate() {
        Attribute isolationLevel = this.attributes.attribute(LockingConfiguration.ISOLATION_LEVEL);
        if (this.getBuilder().clustering().cacheMode().isClustered() && isolationLevel.get() == IsolationLevel.NONE) {
            isolationLevel.set((Object)IsolationLevel.READ_COMMITTED);
        }
        if (isolationLevel.get() == IsolationLevel.READ_UNCOMMITTED) {
            isolationLevel.set((Object)IsolationLevel.READ_COMMITTED);
        }
        if (isolationLevel.get() == IsolationLevel.SERIALIZABLE) {
            isolationLevel.set((Object)IsolationLevel.REPEATABLE_READ);
        }
    }

    @Override
    public void validate(GlobalConfiguration globalConfig) {
    }

    public LockingConfiguration create() {
        return new LockingConfiguration(this.attributes.protect());
    }

    public LockingConfigurationBuilder read(LockingConfiguration template, Combine combine) {
        this.attributes.read(template.attributes(), combine);
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.attributes) + "]";
    }
}

