/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Properties;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;

public class AbstractStoreConfiguration<T extends StoreConfiguration>
extends ConfigurationElement<AbstractStoreConfiguration<T>>
implements StoreConfiguration {
    public static final AttributeDefinition<Boolean> PURGE_ON_STARTUP = AttributeDefinition.builder((Enum)Attribute.PURGE, (Object)false).immutable().build();
    public static final AttributeDefinition<Boolean> READ_ONLY = AttributeDefinition.builder((Enum)Attribute.READ_ONLY, (Object)false).immutable().build();
    public static final AttributeDefinition<Boolean> WRITE_ONLY = AttributeDefinition.builder((Enum)Attribute.WRITE_ONLY, (Object)false).immutable().build();
    public static final AttributeDefinition<Boolean> PRELOAD = AttributeDefinition.builder((Enum)Attribute.PRELOAD, (Object)false).immutable().build();
    public static final AttributeDefinition<Boolean> SHARED = AttributeDefinition.builder((Enum)Attribute.SHARED, (Object)false).immutable().build();
    public static final AttributeDefinition<Boolean> TRANSACTIONAL = AttributeDefinition.builder((Enum)Attribute.TRANSACTIONAL, (Object)false).immutable().build();
    public static final AttributeDefinition<Integer> MAX_BATCH_SIZE = AttributeDefinition.builder((Enum)Attribute.MAX_BATCH_SIZE, (Object)100).immutable().build();
    public static final AttributeDefinition<Boolean> SEGMENTED = AttributeDefinition.builder((Enum)Attribute.SEGMENTED, (Object)true).immutable().build();
    public static final AttributeDefinition<TypedProperties> PROPERTIES = AttributeDefinition.builder((Enum)Element.PROPERTIES, null, TypedProperties.class).initializer(TypedProperties::new).autoPersist(false).immutable().build();
    private final org.infinispan.commons.configuration.attributes.Attribute<Integer> maxBatchSize;
    private final AsyncStoreConfiguration async;

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(AbstractStoreConfiguration.class, new AttributeDefinition[]{PURGE_ON_STARTUP, READ_ONLY, WRITE_ONLY, PRELOAD, SHARED, TRANSACTIONAL, MAX_BATCH_SIZE, SEGMENTED, PROPERTIES});
    }

    protected AbstractStoreConfiguration(Enum<?> element, AttributeSet attributes, AsyncStoreConfiguration async, ConfigurationElement<?> ... children) {
        super(element, attributes, (ConfigurationElement[])Util.concat((Object[])children, (Object)((Object)async)));
        this.async = async;
        this.maxBatchSize = attributes.attribute(MAX_BATCH_SIZE);
    }

    @Override
    public AsyncStoreConfiguration async() {
        return this.async;
    }

    @Override
    public boolean purgeOnStartup() {
        return (Boolean)this.attributes.attribute(PURGE_ON_STARTUP).get();
    }

    @Override
    public boolean shared() {
        return (Boolean)this.attributes.attribute(SHARED).get();
    }

    @Override
    public boolean transactional() {
        return (Boolean)this.attributes.attribute(TRANSACTIONAL).get();
    }

    @Override
    public int maxBatchSize() {
        return (Integer)this.maxBatchSize.get();
    }

    @Override
    public boolean segmented() {
        return (Boolean)this.attributes.attribute(SEGMENTED).get();
    }

    @Override
    @Deprecated(forRemoval=true, since="14.0")
    public boolean fetchPersistentState() {
        return false;
    }

    @Override
    public boolean ignoreModifications() {
        return (Boolean)this.attributes.attribute(READ_ONLY).get();
    }

    @Override
    public boolean writeOnly() {
        return (Boolean)this.attributes.attribute(WRITE_ONLY).get();
    }

    @Override
    public boolean preload() {
        return (Boolean)this.attributes.attribute(PRELOAD).get();
    }

    @Override
    public Properties properties() {
        return (Properties)this.attributes.attribute(PROPERTIES).get();
    }
}

