/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.infinispan.commands.AbstractTopologyAffectedCommand;
import org.infinispan.commands.CommandInvocationId;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.write.ValueMatcher;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.Util;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.marshall.protostream.impl.MarshallableArray;
import org.infinispan.metadata.impl.PrivateMetadata;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.util.ByteString;
import org.infinispan.util.concurrent.locks.RemoteLockCommand;

@ProtoTypeId(value=26)
public class InvalidateCommand
extends AbstractTopologyAffectedCommand
implements WriteCommand,
RemoteLockCommand {
    protected Object[] keys;
    protected CommandInvocationId commandInvocationId;

    public InvalidateCommand(ByteString cacheName, long flagsBitSet, CommandInvocationId commandInvocationId, Object ... keys) {
        super(cacheName, flagsBitSet, -1);
        this.keys = keys;
        this.commandInvocationId = commandInvocationId;
    }

    public InvalidateCommand(ByteString cacheName, long flagsBitSet, Collection<Object> keys, CommandInvocationId commandInvocationId) {
        this(cacheName, flagsBitSet, commandInvocationId, keys == null || keys.isEmpty() ? Util.EMPTY_OBJECT_ARRAY : keys.toArray());
    }

    @ProtoFactory
    protected InvalidateCommand(ByteString cacheName, long flagsWithoutRemote, int topologyId, CommandInvocationId commandInvocationId, MarshallableArray<Object> wrappedKeys) {
        super(cacheName, flagsWithoutRemote, topologyId);
        this.keys = MarshallableArray.unwrap(wrappedKeys);
        this.commandInvocationId = commandInvocationId;
    }

    @ProtoField(number=4, name="keys")
    public MarshallableArray<Object> getWrappedKeys() {
        return MarshallableArray.create(this.keys);
    }

    @Override
    @ProtoField(value=5)
    public CommandInvocationId getCommandInvocationId() {
        return this.commandInvocationId;
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitInvalidateCommand(ctx, this);
    }

    public Object[] getKeys() {
        return this.keys;
    }

    @Override
    public boolean isSuccessful() {
        return true;
    }

    @Override
    public boolean isConditional() {
        return false;
    }

    @Override
    public ValueMatcher getValueMatcher() {
        return ValueMatcher.MATCH_ALWAYS;
    }

    @Override
    public void setValueMatcher(ValueMatcher valueMatcher) {
    }

    @Override
    public Collection<?> getAffectedKeys() {
        return new HashSet<Object>(Arrays.asList(this.keys));
    }

    @Override
    public void fail() {
        throw new UnsupportedOperationException();
    }

    @Override
    public PrivateMetadata getInternalMetadata(Object key) {
        return null;
    }

    @Override
    public void setInternalMetadata(Object key, PrivateMetadata internalMetadata) {
    }

    @Override
    public Collection<?> getKeysToLock() {
        return Arrays.asList(this.keys);
    }

    @Override
    public Object getKeyLockOwner() {
        return this.commandInvocationId;
    }

    @Override
    public boolean hasZeroLockAcquisition() {
        return this.hasAnyFlag(FlagBitSets.ZERO_LOCK_ACQUISITION_TIMEOUT);
    }

    @Override
    public boolean hasSkipLocking() {
        return this.hasAnyFlag(FlagBitSets.SKIP_LOCKING);
    }

    @Override
    public VisitableCommand.LoadType loadType() {
        return VisitableCommand.LoadType.DONT_LOAD;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InvalidateCommand that = (InvalidateCommand)obj;
        if (!this.hasSameFlags(that)) {
            return false;
        }
        return Arrays.equals(this.keys, that.keys);
    }

    public int hashCode() {
        return this.keys != null ? Arrays.hashCode(this.keys) : 0;
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    public String toString() {
        return "InvalidateCommand{keys=" + Util.toStr(Arrays.asList(this.keys)) + "}";
    }
}

