/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.statetransfer;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.conflict.impl.StateReceiver;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.statetransfer.StateChunk;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.util.ByteString;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ProtoTypeId(value=1175)
public class StateResponseCommand
extends BaseRpcCommand
implements TopologyAffectedCommand {
    private static final Log log = LogFactory.getLog(StateResponseCommand.class);
    @ProtoField(value=2)
    int topologyId;
    @ProtoField(value=3)
    Collection<StateChunk> stateChunks;
    @ProtoField(value=4)
    boolean applyState;

    @ProtoFactory
    public StateResponseCommand(ByteString cacheName, int topologyId, Collection<StateChunk> stateChunks, boolean applyState) {
        super(cacheName);
        this.topologyId = topologyId;
        this.stateChunks = stateChunks;
        this.applyState = applyState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletionStage<?> invokeAsync(ComponentRegistry componentRegistry) throws Throwable {
        boolean trace = log.isTraceEnabled();
        LogFactory.pushNDC(this.cacheName, trace);
        try {
            if (this.applyState) {
                StateConsumer stateConsumer = componentRegistry.getStateTransferManager().getStateConsumer();
                CompletionStage<?> completionStage = stateConsumer.applyState(this.origin, this.topologyId, this.stateChunks);
                return completionStage;
            }
            StateReceiver stateReceiver = componentRegistry.getConflictManager().running().getStateReceiver();
            stateReceiver.receiveState(this.origin, this.topologyId, this.stateChunks);
            CompletableFuture completableFuture = CompletableFutures.completedNull();
            return completableFuture;
        }
        finally {
            LogFactory.popNDC(trace);
        }
    }

    @Override
    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    public Collection<StateChunk> getStateChunks() {
        return this.stateChunks;
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    @Override
    public String toString() {
        return "StateResponseCommand{cache=" + String.valueOf(this.cacheName) + ", stateChunks=" + String.valueOf(this.stateChunks) + ", origin=" + String.valueOf(this.origin) + ", topologyId=" + this.topologyId + ", applyState=" + this.applyState + "}";
    }
}

