/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.irac;

import java.util.Collection;
import java.util.concurrent.CompletionStage;
import org.infinispan.commands.irac.BaseIracCommand;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.container.versioning.irac.IracTombstoneInfo;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;
import org.infinispan.protostream.annotations.ProtoTypeId;
import org.infinispan.remoting.transport.NodeVersion;
import org.infinispan.util.ByteString;

@ProtoTypeId(value=1108)
public class IracTombstonePrimaryCheckCommand
extends BaseIracCommand {
    @ProtoField(value=2)
    final Collection<IracTombstoneInfo> tombstoneToCheck;

    @ProtoFactory
    public IracTombstonePrimaryCheckCommand(ByteString cacheName, Collection<IracTombstoneInfo> tombstoneToCheck) {
        super(cacheName);
        this.tombstoneToCheck = tombstoneToCheck;
    }

    public CompletionStage<Void> invokeAsync(ComponentRegistry registry) {
        registry.getIracTombstoneManager().running().checkStaleTombstone(this.tombstoneToCheck);
        return CompletableFutures.completedNull();
    }

    @Override
    public NodeVersion supportedSince() {
        return NodeVersion.SIXTEEN;
    }

    public String toString() {
        return "IracTombstonePrimaryCheckCommand{cacheName=" + String.valueOf(this.cacheName) + ", tombstoneToCheck=" + String.valueOf(this.tombstoneToCheck) + "}";
    }

    public Collection<IracTombstoneInfo> getTombstoneToCheck() {
        return this.tombstoneToCheck;
    }
}

