/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.util.TimeQuantity;
import org.infinispan.configuration.cache.IsolationLevel;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;

public class LockingConfiguration
extends ConfigurationElement<LockingConfiguration> {
    public static final AttributeDefinition<Integer> CONCURRENCY_LEVEL = AttributeDefinition.builder((Enum)Attribute.CONCURRENCY_LEVEL, (Object)32).immutable().build();
    public static final AttributeDefinition<IsolationLevel> ISOLATION_LEVEL = AttributeDefinition.builder((Enum)Attribute.ISOLATION, (Object)((Object)IsolationLevel.REPEATABLE_READ)).immutable().build();
    public static final AttributeDefinition<TimeQuantity> LOCK_ACQUISITION_TIMEOUT = AttributeDefinition.builder((Enum)Attribute.ACQUIRE_TIMEOUT, (Object)TimeQuantity.valueOf((String)"10s")).parser(TimeQuantity.PARSER).build();
    public static final AttributeDefinition<Boolean> USE_LOCK_STRIPING = AttributeDefinition.builder((Enum)Attribute.STRIPING, (Object)false).immutable().build();
    private final org.infinispan.commons.configuration.attributes.Attribute<Integer> concurrencyLevel;
    private final org.infinispan.commons.configuration.attributes.Attribute<IsolationLevel> isolationLevel;
    private final org.infinispan.commons.configuration.attributes.Attribute<TimeQuantity> lockAcquisitionTimeout;
    private final org.infinispan.commons.configuration.attributes.Attribute<Boolean> useLockStriping;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(LockingConfiguration.class, Element.LOCKING.toString(), null, new AttributeDefinition[]{CONCURRENCY_LEVEL, ISOLATION_LEVEL, LOCK_ACQUISITION_TIMEOUT, USE_LOCK_STRIPING}, new AttributeSet.RemovedAttribute[]{new AttributeSet.RemovedAttribute((Enum)Attribute.WRITE_SKEW_CHECK, 10, 0)});
    }

    LockingConfiguration(AttributeSet attributes) {
        super((Enum)Element.LOCKING, attributes, new ConfigurationElement[0]);
        this.concurrencyLevel = attributes.attribute(CONCURRENCY_LEVEL);
        this.isolationLevel = attributes.attribute(ISOLATION_LEVEL);
        this.lockAcquisitionTimeout = attributes.attribute(LOCK_ACQUISITION_TIMEOUT);
        this.useLockStriping = attributes.attribute(USE_LOCK_STRIPING);
    }

    public int concurrencyLevel() {
        return (Integer)this.concurrencyLevel.get();
    }

    public IsolationLevel lockIsolationLevel() {
        return (IsolationLevel)((Object)this.isolationLevel.get());
    }

    @Deprecated(forRemoval=true, since="15.0")
    public org.infinispan.util.concurrent.IsolationLevel isolationLevel() {
        return org.infinispan.util.concurrent.IsolationLevel.from((IsolationLevel)((Object)this.isolationLevel.get()));
    }

    public long lockAcquisitionTimeout() {
        return ((TimeQuantity)this.lockAcquisitionTimeout.get()).longValue();
    }

    public LockingConfiguration lockAcquisitionTimeout(long timeout) {
        this.lockAcquisitionTimeout.set((Object)TimeQuantity.valueOf((long)timeout));
        return this;
    }

    public LockingConfiguration lockAcquisitionTimeout(String timeout) {
        this.lockAcquisitionTimeout.set((Object)TimeQuantity.valueOf((String)timeout));
        return this;
    }

    public boolean useLockStriping() {
        return (Boolean)this.useLockStriping.get();
    }
}

