package org.infinispan.remoting.transport.jgroups;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.processing.Generated;
import org.infinispan.commons.stat.GaugeMetricInfo;
import org.infinispan.commons.stat.MetricInfo;
import org.jgroups.stack.Protocol;

@Generated(value = "org.infinispan.component.processor.external.JGroupsComponentProcessor", date = "2024-11-18T19:34:46.339369822Z")
public class JGroupsMetricsMetadata {
   public static final Map<Class<? extends Protocol>, Collection<MetricInfo>> PROTOCOL_METADATA = new HashMap<>();
   private JGroupsMetricsMetadata() {}
   static {
      List<MetricInfo> attributes;
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getNumSuspectedMembers", "The number of currently suspected members", null, org.jgroups.protocols.FD_SOCK::getNumSuspectedMembers));
      attributes.add(new GaugeMetricInfo<>("getNumSuspectEventsGenerated", "Number of suspect event generated", null, org.jgroups.protocols.FD_SOCK::getNumSuspectEventsGenerated));
      attributes.add(new GaugeMetricInfo<>("getClientBindPortActual", "The actual client_bind_port", null, org.jgroups.protocols.FD_SOCK::getClientBindPortActual));
      PROTOCOL_METADATA.put(org.jgroups.protocols.FD_SOCK.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getNumberOfReceivedFragments", "Number of received fragments", null, org.jgroups.protocols.FRAG::getNumberOfReceivedFragments));
      attributes.add(new GaugeMetricInfo<>("getNumberOfSentFragments", "Number of sent fragments", null, org.jgroups.protocols.FRAG::getNumberOfSentFragments));
      PROTOCOL_METADATA.put(org.jgroups.protocols.FRAG.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getNumberOfReceivedFragments", "Number of received fragments", null, org.jgroups.protocols.FRAG2::getNumberOfReceivedFragments));
      attributes.add(new GaugeMetricInfo<>("getNumberOfSentFragments", "Number of sent fragments", null, org.jgroups.protocols.FRAG2::getNumberOfSentFragments));
      PROTOCOL_METADATA.put(org.jgroups.protocols.FRAG2.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getViewHandlerSize", "", null, org.jgroups.protocols.pbcast.GMS::getViewHandlerSize));
      PROTOCOL_METADATA.put(org.jgroups.protocols.pbcast.GMS.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getStableSent", "", null, org.jgroups.protocols.pbcast.STABLE::getStableSent));
      attributes.add(new GaugeMetricInfo<>("getStableReceived", "", null, org.jgroups.protocols.pbcast.STABLE::getStableReceived));
      attributes.add(new GaugeMetricInfo<>("getStabilitySent", "", null, org.jgroups.protocols.pbcast.STABLE::getStabilitySent));
      attributes.add(new GaugeMetricInfo<>("getStabilityReceived", "", null, org.jgroups.protocols.pbcast.STABLE::getStabilityReceived));
      attributes.add(new GaugeMetricInfo<>("getNumVotes", "The number of votes for the current digest", null, org.jgroups.protocols.pbcast.STABLE::getNumVotes));
      PROTOCOL_METADATA.put(org.jgroups.protocols.pbcast.STABLE.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getNumberOfStateRequests", "", null, org.jgroups.protocols.pbcast.STATE_TRANSFER::getNumberOfStateRequests));
      attributes.add(new GaugeMetricInfo<>("getNumberOfStateBytesSent", "", null, org.jgroups.protocols.pbcast.STATE_TRANSFER::getNumberOfStateBytesSent));
      attributes.add(new GaugeMetricInfo<>("getAverageStateSize", "", null, org.jgroups.protocols.pbcast.STATE_TRANSFER::getAverageStateSize));
      PROTOCOL_METADATA.put(org.jgroups.protocols.pbcast.STATE_TRANSFER.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getNumCompressions", "Number of compressions", null, org.jgroups.protocols.COMPRESS::getNumCompressions));
      attributes.add(new GaugeMetricInfo<>("getNumUncompressions", "Number of un-compressions", null, org.jgroups.protocols.COMPRESS::getNumUncompressions));
      PROTOCOL_METADATA.put(org.jgroups.protocols.COMPRESS.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getDroppedMessages", "Number of messages dropped when sending because of insufficient buffer space", null, org.jgroups.protocols.UDP::getDroppedMessages));
      attributes.add(new GaugeMetricInfo<>("getDifferentClusterMessages", "Number of messages from members in a different cluster", null, org.jgroups.protocols.UDP::getDifferentClusterMessages));
      attributes.add(new GaugeMetricInfo<>("getDifferentVersionMessages", "Number of messages from members with a different JGroups version", null, org.jgroups.protocols.UDP::getDifferentVersionMessages));
      attributes.add(new GaugeMetricInfo<>("getNumTimerTasks", "Number of timer tasks queued up for execution", null, org.jgroups.protocols.UDP::getNumTimerTasks));
      attributes.add(new GaugeMetricInfo<>("getTimerThreads", "Number of threads currently in the pool", null, org.jgroups.protocols.UDP::getTimerThreads));
      attributes.add(new GaugeMetricInfo<>("getThreadPoolSize", "Current number of threads in the thread pool", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getThreadPool().getThreadPoolSize())));
      attributes.add(new GaugeMetricInfo<>("getNumberOfThreadDumps", "Number of thread dumps", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getThreadPool().getNumberOfThreadDumps())));
      attributes.add(new GaugeMetricInfo<>("getThreadPoolSizeActive", "Current number of active threads in the thread pool", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getThreadPool().getThreadPoolSizeActive())));
      attributes.add(new GaugeMetricInfo<>("getLargestSize", "Largest number of threads in the thread pool", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getThreadPool().getLargestSize())));
      attributes.add(new GaugeMetricInfo<>("getNumMsgsSent", "Number of messages sent", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastMsgsSent", "Number of unicast messages sent", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumUcastMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastMsgsSent", "Number of multicast messages sent", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumMcastMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastMsgsReceived", "Number of unicast messages received", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumUcastMsgsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastMsgsReceived", "Number of multicast messages received", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumMcastMsgsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMsgsReceived", "Number of regular messages received", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumMsgsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumOOBMsgsReceived", "Number of OOB messages received. This value is included in num_msgs_received.", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumOOBMsgsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumSingleMsgsSent", "Number of single messages sent", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumSingleMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumBatchesSent", "Number of message batches sent", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumBatchesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumBatchesReceived", "Number of message batches received", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumBatchesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumBytesSent", "Number of bytes sent", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastBytesSent", "Number of unicast bytes sent", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumUcastBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastBytesSent", "Number of multicast bytes sent", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumMcastBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumBytesReceived", "Number of bytes received", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastBytesReceived", "Number of unicast bytes received", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumUcastBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastBytesReceived", "Number of multicast bytes received", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumMcastBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumRejectedMsgs", "Number of dropped messages that were rejected by the thread pool", null, ((Function<org.jgroups.protocols.UDP, Number>) p -> p.getMessageStats().getNumRejectedMsgs())));
      PROTOCOL_METADATA.put(org.jgroups.protocols.UDP.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getOpenConnections", "", null, org.jgroups.protocols.TCP::getOpenConnections));
      attributes.add(new GaugeMetricInfo<>("getDifferentClusterMessages", "Number of messages from members in a different cluster", null, org.jgroups.protocols.TCP::getDifferentClusterMessages));
      attributes.add(new GaugeMetricInfo<>("getDifferentVersionMessages", "Number of messages from members with a different JGroups version", null, org.jgroups.protocols.TCP::getDifferentVersionMessages));
      attributes.add(new GaugeMetricInfo<>("getNumTimerTasks", "Number of timer tasks queued up for execution", null, org.jgroups.protocols.TCP::getNumTimerTasks));
      attributes.add(new GaugeMetricInfo<>("getTimerThreads", "Number of threads currently in the pool", null, org.jgroups.protocols.TCP::getTimerThreads));
      attributes.add(new GaugeMetricInfo<>("getThreadPoolSize", "Current number of threads in the thread pool", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getThreadPool().getThreadPoolSize())));
      attributes.add(new GaugeMetricInfo<>("getNumberOfThreadDumps", "Number of thread dumps", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getThreadPool().getNumberOfThreadDumps())));
      attributes.add(new GaugeMetricInfo<>("getThreadPoolSizeActive", "Current number of active threads in the thread pool", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getThreadPool().getThreadPoolSizeActive())));
      attributes.add(new GaugeMetricInfo<>("getLargestSize", "Largest number of threads in the thread pool", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getThreadPool().getLargestSize())));
      attributes.add(new GaugeMetricInfo<>("getNumMsgsSent", "Number of messages sent", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastMsgsSent", "Number of unicast messages sent", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumUcastMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastMsgsSent", "Number of multicast messages sent", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumMcastMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastMsgsReceived", "Number of unicast messages received", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumUcastMsgsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastMsgsReceived", "Number of multicast messages received", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumMcastMsgsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMsgsReceived", "Number of regular messages received", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumMsgsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumOOBMsgsReceived", "Number of OOB messages received. This value is included in num_msgs_received.", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumOOBMsgsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumSingleMsgsSent", "Number of single messages sent", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumSingleMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumBatchesSent", "Number of message batches sent", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumBatchesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumBatchesReceived", "Number of message batches received", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumBatchesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumBytesSent", "Number of bytes sent", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastBytesSent", "Number of unicast bytes sent", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumUcastBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastBytesSent", "Number of multicast bytes sent", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumMcastBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumBytesReceived", "Number of bytes received", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastBytesReceived", "Number of unicast bytes received", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumUcastBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastBytesReceived", "Number of multicast bytes received", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumMcastBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumRejectedMsgs", "Number of dropped messages that were rejected by the thread pool", null, ((Function<org.jgroups.protocols.TCP, Number>) p -> p.getMessageStats().getNumRejectedMsgs())));
      PROTOCOL_METADATA.put(org.jgroups.protocols.TCP.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getDifferentClusterMessages", "Number of messages from members in a different cluster", null, org.jgroups.protocols.TUNNEL::getDifferentClusterMessages));
      attributes.add(new GaugeMetricInfo<>("getDifferentVersionMessages", "Number of messages from members with a different JGroups version", null, org.jgroups.protocols.TUNNEL::getDifferentVersionMessages));
      attributes.add(new GaugeMetricInfo<>("getNumTimerTasks", "Number of timer tasks queued up for execution", null, org.jgroups.protocols.TUNNEL::getNumTimerTasks));
      attributes.add(new GaugeMetricInfo<>("getTimerThreads", "Number of threads currently in the pool", null, org.jgroups.protocols.TUNNEL::getTimerThreads));
      attributes.add(new GaugeMetricInfo<>("getThreadPoolSize", "Current number of threads in the thread pool", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getThreadPool().getThreadPoolSize())));
      attributes.add(new GaugeMetricInfo<>("getNumberOfThreadDumps", "Number of thread dumps", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getThreadPool().getNumberOfThreadDumps())));
      attributes.add(new GaugeMetricInfo<>("getThreadPoolSizeActive", "Current number of active threads in the thread pool", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getThreadPool().getThreadPoolSizeActive())));
      attributes.add(new GaugeMetricInfo<>("getLargestSize", "Largest number of threads in the thread pool", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getThreadPool().getLargestSize())));
      attributes.add(new GaugeMetricInfo<>("getNumMsgsSent", "Number of messages sent", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastMsgsSent", "Number of unicast messages sent", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumUcastMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastMsgsSent", "Number of multicast messages sent", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumMcastMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastMsgsReceived", "Number of unicast messages received", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumUcastMsgsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastMsgsReceived", "Number of multicast messages received", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumMcastMsgsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMsgsReceived", "Number of regular messages received", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumMsgsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumOOBMsgsReceived", "Number of OOB messages received. This value is included in num_msgs_received.", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumOOBMsgsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumSingleMsgsSent", "Number of single messages sent", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumSingleMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumBatchesSent", "Number of message batches sent", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumBatchesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumBatchesReceived", "Number of message batches received", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumBatchesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumBytesSent", "Number of bytes sent", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastBytesSent", "Number of unicast bytes sent", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumUcastBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastBytesSent", "Number of multicast bytes sent", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumMcastBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumBytesReceived", "Number of bytes received", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastBytesReceived", "Number of unicast bytes received", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumUcastBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastBytesReceived", "Number of multicast bytes received", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumMcastBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumRejectedMsgs", "Number of dropped messages that were rejected by the thread pool", null, ((Function<org.jgroups.protocols.TUNNEL, Number>) p -> p.getMessageStats().getNumRejectedMsgs())));
      PROTOCOL_METADATA.put(org.jgroups.protocols.TUNNEL.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getForwardTableSize", "Number of messages in the forward-table", null, org.jgroups.protocols.SEQUENCER::getForwardTableSize));
      PROTOCOL_METADATA.put(org.jgroups.protocols.SEQUENCER.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getAverageFlushDuration", "", null, org.jgroups.protocols.pbcast.FLUSH::getAverageFlushDuration));
      attributes.add(new GaugeMetricInfo<>("getTotalTimeInFlush", "", null, org.jgroups.protocols.pbcast.FLUSH::getTotalTimeInFlush));
      attributes.add(new GaugeMetricInfo<>("getNumberOfFlushes", "", null, org.jgroups.protocols.pbcast.FLUSH::getNumberOfFlushes));
      PROTOCOL_METADATA.put(org.jgroups.protocols.pbcast.FLUSH.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getNumberOfStateRequests", "", null, org.jgroups.protocols.pbcast.STATE::getNumberOfStateRequests));
      attributes.add(new GaugeMetricInfo<>("getNumberOfStateBytesSent", "", null, org.jgroups.protocols.pbcast.STATE::getNumberOfStateBytesSent));
      attributes.add(new GaugeMetricInfo<>("getAverageStateSize", "", null, org.jgroups.protocols.pbcast.STATE::getAverageStateSize));
      attributes.add(new GaugeMetricInfo<>("getThreadPoolSize", "", null, org.jgroups.protocols.pbcast.STATE::getThreadPoolSize));
      attributes.add(new GaugeMetricInfo<>("getThreadPoolCompletedTasks", "", null, org.jgroups.protocols.pbcast.STATE::getThreadPoolCompletedTasks));
      PROTOCOL_METADATA.put(org.jgroups.protocols.pbcast.STATE.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getNumberOfStateRequests", "", null, org.jgroups.protocols.pbcast.STATE_SOCK::getNumberOfStateRequests));
      attributes.add(new GaugeMetricInfo<>("getNumberOfStateBytesSent", "", null, org.jgroups.protocols.pbcast.STATE_SOCK::getNumberOfStateBytesSent));
      attributes.add(new GaugeMetricInfo<>("getAverageStateSize", "", null, org.jgroups.protocols.pbcast.STATE_SOCK::getAverageStateSize));
      attributes.add(new GaugeMetricInfo<>("getThreadPoolSize", "", null, org.jgroups.protocols.pbcast.STATE_SOCK::getThreadPoolSize));
      attributes.add(new GaugeMetricInfo<>("getThreadPoolCompletedTasks", "", null, org.jgroups.protocols.pbcast.STATE_SOCK::getThreadPoolCompletedTasks));
      PROTOCOL_METADATA.put(org.jgroups.protocols.pbcast.STATE_SOCK.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getDifferentClusterMessages", "Number of messages from members in a different cluster", null, org.jgroups.protocols.SHARED_LOOPBACK::getDifferentClusterMessages));
      attributes.add(new GaugeMetricInfo<>("getDifferentVersionMessages", "Number of messages from members with a different JGroups version", null, org.jgroups.protocols.SHARED_LOOPBACK::getDifferentVersionMessages));
      attributes.add(new GaugeMetricInfo<>("getNumTimerTasks", "Number of timer tasks queued up for execution", null, org.jgroups.protocols.SHARED_LOOPBACK::getNumTimerTasks));
      attributes.add(new GaugeMetricInfo<>("getTimerThreads", "Number of threads currently in the pool", null, org.jgroups.protocols.SHARED_LOOPBACK::getTimerThreads));
      attributes.add(new GaugeMetricInfo<>("getThreadPoolSize", "Current number of threads in the thread pool", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getThreadPool().getThreadPoolSize())));
      attributes.add(new GaugeMetricInfo<>("getNumberOfThreadDumps", "Number of thread dumps", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getThreadPool().getNumberOfThreadDumps())));
      attributes.add(new GaugeMetricInfo<>("getThreadPoolSizeActive", "Current number of active threads in the thread pool", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getThreadPool().getThreadPoolSizeActive())));
      attributes.add(new GaugeMetricInfo<>("getLargestSize", "Largest number of threads in the thread pool", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getThreadPool().getLargestSize())));
      attributes.add(new GaugeMetricInfo<>("getNumMsgsSent", "Number of messages sent", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastMsgsSent", "Number of unicast messages sent", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumUcastMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastMsgsSent", "Number of multicast messages sent", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumMcastMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastMsgsReceived", "Number of unicast messages received", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumUcastMsgsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastMsgsReceived", "Number of multicast messages received", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumMcastMsgsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMsgsReceived", "Number of regular messages received", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumMsgsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumOOBMsgsReceived", "Number of OOB messages received. This value is included in num_msgs_received.", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumOOBMsgsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumSingleMsgsSent", "Number of single messages sent", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumSingleMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumBatchesSent", "Number of message batches sent", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumBatchesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumBatchesReceived", "Number of message batches received", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumBatchesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumBytesSent", "Number of bytes sent", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastBytesSent", "Number of unicast bytes sent", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumUcastBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastBytesSent", "Number of multicast bytes sent", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumMcastBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumBytesReceived", "Number of bytes received", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastBytesReceived", "Number of unicast bytes received", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumUcastBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastBytesReceived", "Number of multicast bytes received", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumMcastBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumRejectedMsgs", "Number of dropped messages that were rejected by the thread pool", null, ((Function<org.jgroups.protocols.SHARED_LOOPBACK, Number>) p -> p.getMessageStats().getNumRejectedMsgs())));
      PROTOCOL_METADATA.put(org.jgroups.protocols.SHARED_LOOPBACK.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getNumberOfBlockings", "Number of times flow control blocks sender", null, org.jgroups.protocols.MFC::getNumberOfBlockings));
      attributes.add(new GaugeMetricInfo<>("getAverageTimeBlocked", "Average time blocked (in ms) in flow control when trying to send a message", null, org.jgroups.protocols.MFC::getAverageTimeBlocked));
      attributes.add(new GaugeMetricInfo<>("getNumberOfCreditRequestsReceived", "Number of credit requests received", null, org.jgroups.protocols.MFC::getNumberOfCreditRequestsReceived));
      attributes.add(new GaugeMetricInfo<>("getNumberOfCreditRequestsSent", "Number of credit requests sent", null, org.jgroups.protocols.MFC::getNumberOfCreditRequestsSent));
      attributes.add(new GaugeMetricInfo<>("getNumberOfCreditResponsesReceived", "Number of credit responses received", null, org.jgroups.protocols.MFC::getNumberOfCreditResponsesReceived));
      attributes.add(new GaugeMetricInfo<>("getNumberOfCreditResponsesSent", "Number of credit responses sent", null, org.jgroups.protocols.MFC::getNumberOfCreditResponsesSent));
      PROTOCOL_METADATA.put(org.jgroups.protocols.MFC.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getNumberOfBlockings", "Number of times flow control blocks sender", null, org.jgroups.protocols.UFC::getNumberOfBlockings));
      attributes.add(new GaugeMetricInfo<>("getAverageTimeBlocked", "Average time blocked (in ms) in flow control when trying to send a message", null, org.jgroups.protocols.UFC::getAverageTimeBlocked));
      attributes.add(new GaugeMetricInfo<>("getNumberOfCreditRequestsReceived", "Number of credit requests received", null, org.jgroups.protocols.UFC::getNumberOfCreditRequestsReceived));
      attributes.add(new GaugeMetricInfo<>("getNumberOfCreditRequestsSent", "Number of credit requests sent", null, org.jgroups.protocols.UFC::getNumberOfCreditRequestsSent));
      attributes.add(new GaugeMetricInfo<>("getNumberOfCreditResponsesReceived", "Number of credit responses received", null, org.jgroups.protocols.UFC::getNumberOfCreditResponsesReceived));
      attributes.add(new GaugeMetricInfo<>("getNumberOfCreditResponsesSent", "Number of credit responses sent", null, org.jgroups.protocols.UFC::getNumberOfCreditResponsesSent));
      PROTOCOL_METADATA.put(org.jgroups.protocols.UFC.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getNumConnections", "Number of client connections", null, org.jgroups.protocols.STOMP::getNumConnections));
      attributes.add(new GaugeMetricInfo<>("getNumSubscriptions", "Number of subscriptions", null, org.jgroups.protocols.STOMP::getNumSubscriptions));
      PROTOCOL_METADATA.put(org.jgroups.protocols.STOMP.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getNumServerLocks", "Number of server locks (only on coord)", null, org.jgroups.protocols.CENTRAL_LOCK::getNumServerLocks));
      attributes.add(new GaugeMetricInfo<>("getNumClientLocks", "Number of client locks", null, org.jgroups.protocols.CENTRAL_LOCK::getNumClientLocks));
      PROTOCOL_METADATA.put(org.jgroups.protocols.CENTRAL_LOCK.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getViews", "Number of cached ViewIds", null, org.jgroups.protocols.MERGE3::getViews));
      PROTOCOL_METADATA.put(org.jgroups.protocols.MERGE3.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getPendingRsvpRequests", "Number of pending RSVP requests", null, org.jgroups.protocols.RSVP::getPendingRsvpRequests));
      PROTOCOL_METADATA.put(org.jgroups.protocols.RSVP.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getNonMemberMessages", "Number of messages from non-members", null, org.jgroups.protocols.pbcast.NAKACK2::getNonMemberMessages));
      attributes.add(new GaugeMetricInfo<>("getBecomeServerQueueSizeActual", "Actual size of the become_server_queue", null, org.jgroups.protocols.pbcast.NAKACK2::getBecomeServerQueueSizeActual));
      attributes.add(new GaugeMetricInfo<>("getXmitTableUndeliveredMsgs", "Total number of undelivered messages in all retransmit buffers", null, org.jgroups.protocols.pbcast.NAKACK2::getXmitTableUndeliveredMsgs));
      attributes.add(new GaugeMetricInfo<>("getXmitTableMissingMessages", "Total number of missing (= not received) messages in all retransmit buffers", null, org.jgroups.protocols.pbcast.NAKACK2::getXmitTableMissingMessages));
      attributes.add(new GaugeMetricInfo<>("getXmitTableCapacity", "Capacity of the retransmit buffer. Computed as xmit_table_num_rows * xmit_table_msgs_per_row", null, org.jgroups.protocols.pbcast.NAKACK2::getXmitTableCapacity));
      attributes.add(new GaugeMetricInfo<>("getXmitTableNumCurrentRows", "Prints the number of rows currently allocated in the matrix. This value will not be lower than xmit_table_now_rows", null, org.jgroups.protocols.pbcast.NAKACK2::getXmitTableNumCurrentRows));
      attributes.add(new GaugeMetricInfo<>("getSizeOfAllMessages", "Returns the number of bytes of all messages in all retransmit buffers. To compute the size, Message.getLength() is used", null, org.jgroups.protocols.pbcast.NAKACK2::getSizeOfAllMessages));
      attributes.add(new GaugeMetricInfo<>("getSizeOfAllMessagesInclHeaders", "Returns the number of bytes of all messages in all retransmit buffers. To compute the size, Message.size() is used", null, org.jgroups.protocols.pbcast.NAKACK2::getSizeOfAllMessagesInclHeaders));
      attributes.add(new GaugeMetricInfo<>("getXmitTableNumCompactions", "Number of retransmit table compactions", null, org.jgroups.protocols.pbcast.NAKACK2::getXmitTableNumCompactions));
      attributes.add(new GaugeMetricInfo<>("getXmitTableNumMoves", "Number of retransmit table moves", null, org.jgroups.protocols.pbcast.NAKACK2::getXmitTableNumMoves));
      attributes.add(new GaugeMetricInfo<>("getXmitTableNumResizes", "Number of retransmit table resizes", null, org.jgroups.protocols.pbcast.NAKACK2::getXmitTableNumResizes));
      attributes.add(new GaugeMetricInfo<>("getXmitTableNumPurges", "Number of retransmit table purges", null, org.jgroups.protocols.pbcast.NAKACK2::getXmitTableNumPurges));
      attributes.add(new GaugeMetricInfo<>("getCurrentSeqno", "", null, org.jgroups.protocols.pbcast.NAKACK2::getCurrentSeqno));
      PROTOCOL_METADATA.put(org.jgroups.protocols.pbcast.NAKACK2.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getNumForwardedToSiteMaster", "Number of messages forwarded to the local SiteMaster", null, org.jgroups.protocols.relay.RELAY2::getNumForwardedToSiteMaster));
      attributes.add(new GaugeMetricInfo<>("getTimeForwardingToSM", "The total time (in ms) spent forwarding messages to the local SiteMaster", null, org.jgroups.protocols.relay.RELAY2::getTimeForwardingToSM));
      attributes.add(new GaugeMetricInfo<>("getAvgMsgsForwardingToSM", "The average number of messages / s for forwarding messages to the local SiteMaster", null, org.jgroups.protocols.relay.RELAY2::getAvgMsgsForwardingToSM));
      attributes.add(new GaugeMetricInfo<>("getNumRelayed", "Number of messages sent by this SiteMaster to a remote SiteMaster", null, org.jgroups.protocols.relay.RELAY2::getNumRelayed));
      attributes.add(new GaugeMetricInfo<>("getTimeRelaying", "The total time (ms) spent relaying messages from this SiteMaster to remote SiteMasters", null, org.jgroups.protocols.relay.RELAY2::getTimeRelaying));
      attributes.add(new GaugeMetricInfo<>("getAvgMsgsRelaying", "The average number of messages / s for relaying messages from this SiteMaster to remote SiteMasters", null, org.jgroups.protocols.relay.RELAY2::getAvgMsgsRelaying));
      attributes.add(new GaugeMetricInfo<>("getNumForwardedToLocalMbr", "Number of messages (received from a remote Sitemaster and) delivered by this SiteMaster to a local node", null, org.jgroups.protocols.relay.RELAY2::getNumForwardedToLocalMbr));
      attributes.add(new GaugeMetricInfo<>("getTimeForwardingToLocalMbr", "The total time (in ms) spent forwarding messages to a member in the same site", null, org.jgroups.protocols.relay.RELAY2::getTimeForwardingToLocalMbr));
      attributes.add(new GaugeMetricInfo<>("getAvgMsgsForwardingToLocalMbr", "The average number of messages / s for forwarding messages to a member in the same site", null, org.jgroups.protocols.relay.RELAY2::getAvgMsgsForwardingToLocalMbr));
      attributes.add(new GaugeMetricInfo<>("getNumberOfNoRouteErrors", "Number of 'no route to site X' errors", null, org.jgroups.protocols.relay.RELAY2::getNumberOfNoRouteErrors));
      PROTOCOL_METADATA.put(org.jgroups.protocols.relay.RELAY2.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getNumForwardedToSiteMaster", "Number of messages forwarded to the local SiteMaster", null, org.jgroups.protocols.relay.RELAY3::getNumForwardedToSiteMaster));
      attributes.add(new GaugeMetricInfo<>("getTimeForwardingToSM", "The total time (in ms) spent forwarding messages to the local SiteMaster", null, org.jgroups.protocols.relay.RELAY3::getTimeForwardingToSM));
      attributes.add(new GaugeMetricInfo<>("getAvgMsgsForwardingToSM", "The average number of messages / s for forwarding messages to the local SiteMaster", null, org.jgroups.protocols.relay.RELAY3::getAvgMsgsForwardingToSM));
      attributes.add(new GaugeMetricInfo<>("getNumRelayed", "Number of messages sent by this SiteMaster to a remote SiteMaster", null, org.jgroups.protocols.relay.RELAY3::getNumRelayed));
      attributes.add(new GaugeMetricInfo<>("getTimeRelaying", "The total time (ms) spent relaying messages from this SiteMaster to remote SiteMasters", null, org.jgroups.protocols.relay.RELAY3::getTimeRelaying));
      attributes.add(new GaugeMetricInfo<>("getAvgMsgsRelaying", "The average number of messages / s for relaying messages from this SiteMaster to remote SiteMasters", null, org.jgroups.protocols.relay.RELAY3::getAvgMsgsRelaying));
      attributes.add(new GaugeMetricInfo<>("getNumForwardedToLocalMbr", "Number of messages (received from a remote Sitemaster and) delivered by this SiteMaster to a local node", null, org.jgroups.protocols.relay.RELAY3::getNumForwardedToLocalMbr));
      attributes.add(new GaugeMetricInfo<>("getTimeForwardingToLocalMbr", "The total time (in ms) spent forwarding messages to a member in the same site", null, org.jgroups.protocols.relay.RELAY3::getTimeForwardingToLocalMbr));
      attributes.add(new GaugeMetricInfo<>("getAvgMsgsForwardingToLocalMbr", "The average number of messages / s for forwarding messages to a member in the same site", null, org.jgroups.protocols.relay.RELAY3::getAvgMsgsForwardingToLocalMbr));
      attributes.add(new GaugeMetricInfo<>("getNumberOfNoRouteErrors", "Number of 'no route to site X' errors", null, org.jgroups.protocols.relay.RELAY3::getNumberOfNoRouteErrors));
      PROTOCOL_METADATA.put(org.jgroups.protocols.relay.RELAY3.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getNumConnections", "Returns the total number of outgoing (send) and incoming (receive) connections", null, org.jgroups.protocols.UNICAST3::getNumConnections));
      attributes.add(new GaugeMetricInfo<>("getNumLoopbacks", "Number of unicast messages to self looped back up", null, org.jgroups.protocols.UNICAST3::getNumLoopbacks));
      attributes.add(new GaugeMetricInfo<>("getNumSendConnections", "Returns the number of outgoing (send) connections", null, org.jgroups.protocols.UNICAST3::getNumSendConnections));
      attributes.add(new GaugeMetricInfo<>("getNumReceiveConnections", "Returns the number of incoming (receive) connections", null, org.jgroups.protocols.UNICAST3::getNumReceiveConnections));
      attributes.add(new GaugeMetricInfo<>("getTimestamper", "Next seqno issued by the timestamper", null, org.jgroups.protocols.UNICAST3::getTimestamper));
      attributes.add(new GaugeMetricInfo<>("getNumAcksSent", "", null, org.jgroups.protocols.UNICAST3::getNumAcksSent));
      attributes.add(new GaugeMetricInfo<>("getNumAcksReceived", "", null, org.jgroups.protocols.UNICAST3::getNumAcksReceived));
      attributes.add(new GaugeMetricInfo<>("getNumXmits", "", null, org.jgroups.protocols.UNICAST3::getNumXmits));
      attributes.add(new GaugeMetricInfo<>("getAgeOutCacheSize", "", null, org.jgroups.protocols.UNICAST3::getAgeOutCacheSize));
      attributes.add(new GaugeMetricInfo<>("getNumUnackedMessages", "", null, org.jgroups.protocols.UNICAST3::getNumUnackedMessages));
      attributes.add(new GaugeMetricInfo<>("getXmitTableUndeliveredMessages", "Total number of undelivered messages in all receive windows", null, org.jgroups.protocols.UNICAST3::getXmitTableUndeliveredMessages));
      attributes.add(new GaugeMetricInfo<>("getXmitTableDeliverableMessages", "Total number of deliverable messages in all receive windows", null, org.jgroups.protocols.UNICAST3::getXmitTableDeliverableMessages));
      attributes.add(new GaugeMetricInfo<>("getNumMessagesSent", "", null, org.jgroups.protocols.UNICAST3::getNumMessagesSent));
      attributes.add(new GaugeMetricInfo<>("getNumMessagesReceived", "", null, org.jgroups.protocols.UNICAST3::getNumMessagesReceived));
      attributes.add(new GaugeMetricInfo<>("getXmitTableMissingMessages", "Total number of missing messages in all receive windows", null, org.jgroups.protocols.UNICAST3::getXmitTableMissingMessages));
      attributes.add(new GaugeMetricInfo<>("getXmitTableNumCompactions", "Number of compactions in all (receive and send) windows", null, org.jgroups.protocols.UNICAST3::getXmitTableNumCompactions));
      attributes.add(new GaugeMetricInfo<>("getXmitTableNumMoves", "Number of moves in all (receive and send) windows", null, org.jgroups.protocols.UNICAST3::getXmitTableNumMoves));
      attributes.add(new GaugeMetricInfo<>("getXmitTableNumResizes", "Number of resizes in all (receive and send) windows", null, org.jgroups.protocols.UNICAST3::getXmitTableNumResizes));
      attributes.add(new GaugeMetricInfo<>("getXmitTableNumPurges", "Number of purges in all (receive and send) windows", null, org.jgroups.protocols.UNICAST3::getXmitTableNumPurges));
      PROTOCOL_METADATA.put(org.jgroups.protocols.UNICAST3.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("latencyInNs", "Average latency in ns", null, org.jgroups.protocols.PERF::latencyInNs));
      attributes.add(new GaugeMetricInfo<>("latencyInMs", "Average latency in ms", null, org.jgroups.protocols.PERF::latencyInMs));
      PROTOCOL_METADATA.put(org.jgroups.protocols.PERF.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getFwdQueueSize", "Number of messages in the forward-queue", null, org.jgroups.protocols.SEQUENCER2::getFwdQueueSize));
      PROTOCOL_METADATA.put(org.jgroups.protocols.SEQUENCER2.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getOpenConnections", "", null, org.jgroups.protocols.TCP_NIO2::getOpenConnections));
      attributes.add(new GaugeMetricInfo<>("numSelects", "Number of times select() was called", null, org.jgroups.protocols.TCP_NIO2::numSelects));
      attributes.add(new GaugeMetricInfo<>("numPartialWrites", "Number of partial writes for all connections (not all bytes were written)", null, org.jgroups.protocols.TCP_NIO2::numPartialWrites));
      attributes.add(new GaugeMetricInfo<>("getDifferentClusterMessages", "Number of messages from members in a different cluster", null, org.jgroups.protocols.TCP_NIO2::getDifferentClusterMessages));
      attributes.add(new GaugeMetricInfo<>("getDifferentVersionMessages", "Number of messages from members with a different JGroups version", null, org.jgroups.protocols.TCP_NIO2::getDifferentVersionMessages));
      attributes.add(new GaugeMetricInfo<>("getNumTimerTasks", "Number of timer tasks queued up for execution", null, org.jgroups.protocols.TCP_NIO2::getNumTimerTasks));
      attributes.add(new GaugeMetricInfo<>("getTimerThreads", "Number of threads currently in the pool", null, org.jgroups.protocols.TCP_NIO2::getTimerThreads));
      attributes.add(new GaugeMetricInfo<>("getThreadPoolSize", "Current number of threads in the thread pool", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getThreadPool().getThreadPoolSize())));
      attributes.add(new GaugeMetricInfo<>("getNumberOfThreadDumps", "Number of thread dumps", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getThreadPool().getNumberOfThreadDumps())));
      attributes.add(new GaugeMetricInfo<>("getThreadPoolSizeActive", "Current number of active threads in the thread pool", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getThreadPool().getThreadPoolSizeActive())));
      attributes.add(new GaugeMetricInfo<>("getLargestSize", "Largest number of threads in the thread pool", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getThreadPool().getLargestSize())));
      attributes.add(new GaugeMetricInfo<>("getNumMsgsSent", "Number of messages sent", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastMsgsSent", "Number of unicast messages sent", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumUcastMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastMsgsSent", "Number of multicast messages sent", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumMcastMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastMsgsReceived", "Number of unicast messages received", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumUcastMsgsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastMsgsReceived", "Number of multicast messages received", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumMcastMsgsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMsgsReceived", "Number of regular messages received", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumMsgsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumOOBMsgsReceived", "Number of OOB messages received. This value is included in num_msgs_received.", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumOOBMsgsReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumSingleMsgsSent", "Number of single messages sent", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumSingleMsgsSent())));
      attributes.add(new GaugeMetricInfo<>("getNumBatchesSent", "Number of message batches sent", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumBatchesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumBatchesReceived", "Number of message batches received", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumBatchesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumBytesSent", "Number of bytes sent", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastBytesSent", "Number of unicast bytes sent", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumUcastBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastBytesSent", "Number of multicast bytes sent", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumMcastBytesSent())));
      attributes.add(new GaugeMetricInfo<>("getNumBytesReceived", "Number of bytes received", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumUcastBytesReceived", "Number of unicast bytes received", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumUcastBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumMcastBytesReceived", "Number of multicast bytes received", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumMcastBytesReceived())));
      attributes.add(new GaugeMetricInfo<>("getNumRejectedMsgs", "Number of dropped messages that were rejected by the thread pool", null, ((Function<org.jgroups.protocols.TCP_NIO2, Number>) p -> p.getMessageStats().getNumRejectedMsgs())));
      PROTOCOL_METADATA.put(org.jgroups.protocols.TCP_NIO2.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getNumberOfReceivedFragments", "Number of received fragments", null, org.jgroups.protocols.FRAG3::getNumberOfReceivedFragments));
      attributes.add(new GaugeMetricInfo<>("getNumberOfSentFragments", "Number of sent fragments", null, org.jgroups.protocols.FRAG3::getNumberOfSentFragments));
      PROTOCOL_METADATA.put(org.jgroups.protocols.FRAG3.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getNumberOfQueuedMessages", "The number of messages currently queued due to insufficient credit", null, org.jgroups.protocols.UFC_NB::getNumberOfQueuedMessages));
      attributes.add(new GaugeMetricInfo<>("getQueuedSize", "The total size of all currently queued messages for all destinations", null, org.jgroups.protocols.UFC_NB::getQueuedSize));
      attributes.add(new GaugeMetricInfo<>("getNumberOfQueuings", "The number of times messages have been queued due to insufficient credits", null, org.jgroups.protocols.UFC_NB::getNumberOfQueuings));
      attributes.add(new GaugeMetricInfo<>("getNumberOfBlockings", "Number of times flow control blocks sender", null, org.jgroups.protocols.UFC_NB::getNumberOfBlockings));
      attributes.add(new GaugeMetricInfo<>("getAverageTimeBlocked", "Average time blocked (in ms) in flow control when trying to send a message", null, org.jgroups.protocols.UFC_NB::getAverageTimeBlocked));
      attributes.add(new GaugeMetricInfo<>("getNumberOfCreditRequestsReceived", "Number of credit requests received", null, org.jgroups.protocols.UFC_NB::getNumberOfCreditRequestsReceived));
      attributes.add(new GaugeMetricInfo<>("getNumberOfCreditRequestsSent", "Number of credit requests sent", null, org.jgroups.protocols.UFC_NB::getNumberOfCreditRequestsSent));
      attributes.add(new GaugeMetricInfo<>("getNumberOfCreditResponsesReceived", "Number of credit responses received", null, org.jgroups.protocols.UFC_NB::getNumberOfCreditResponsesReceived));
      attributes.add(new GaugeMetricInfo<>("getNumberOfCreditResponsesSent", "Number of credit responses sent", null, org.jgroups.protocols.UFC_NB::getNumberOfCreditResponsesSent));
      PROTOCOL_METADATA.put(org.jgroups.protocols.UFC_NB.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getNumberOfQueuedMessages", "The number of messages currently queued due to insufficient credit", null, org.jgroups.protocols.MFC_NB::getNumberOfQueuedMessages));
      attributes.add(new GaugeMetricInfo<>("getQueuedSize", "The total size of all currently queued messages", null, org.jgroups.protocols.MFC_NB::getQueuedSize));
      attributes.add(new GaugeMetricInfo<>("getNumberOfQueuings", "The number of times messages have been queued due to insufficient credits", null, org.jgroups.protocols.MFC_NB::getNumberOfQueuings));
      attributes.add(new GaugeMetricInfo<>("getNumberOfBlockings", "Number of times flow control blocks sender", null, org.jgroups.protocols.MFC_NB::getNumberOfBlockings));
      attributes.add(new GaugeMetricInfo<>("getAverageTimeBlocked", "Average time blocked (in ms) in flow control when trying to send a message", null, org.jgroups.protocols.MFC_NB::getAverageTimeBlocked));
      attributes.add(new GaugeMetricInfo<>("getNumberOfCreditRequestsReceived", "Number of credit requests received", null, org.jgroups.protocols.MFC_NB::getNumberOfCreditRequestsReceived));
      attributes.add(new GaugeMetricInfo<>("getNumberOfCreditRequestsSent", "Number of credit requests sent", null, org.jgroups.protocols.MFC_NB::getNumberOfCreditRequestsSent));
      attributes.add(new GaugeMetricInfo<>("getNumberOfCreditResponsesReceived", "Number of credit responses received", null, org.jgroups.protocols.MFC_NB::getNumberOfCreditResponsesReceived));
      attributes.add(new GaugeMetricInfo<>("getNumberOfCreditResponsesSent", "Number of credit responses sent", null, org.jgroups.protocols.MFC_NB::getNumberOfCreditResponsesSent));
      PROTOCOL_METADATA.put(org.jgroups.protocols.MFC_NB.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("requestQueueSize", "", null, org.jgroups.protocols.CENTRAL_LOCK2::requestQueueSize));
      attributes.add(new GaugeMetricInfo<>("getNumServerLocks", "Number of server locks (only on coord)", null, org.jgroups.protocols.CENTRAL_LOCK2::getNumServerLocks));
      attributes.add(new GaugeMetricInfo<>("getNumClientLocks", "Number of client locks", null, org.jgroups.protocols.CENTRAL_LOCK2::getNumClientLocks));
      PROTOCOL_METADATA.put(org.jgroups.protocols.CENTRAL_LOCK2.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getNumberOfReceivedFragments", "Number of received fragments", null, org.jgroups.protocols.FRAG4::getNumberOfReceivedFragments));
      attributes.add(new GaugeMetricInfo<>("getNumberOfSentFragments", "Number of sent fragments", null, org.jgroups.protocols.FRAG4::getNumberOfSentFragments));
      PROTOCOL_METADATA.put(org.jgroups.protocols.FRAG4.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getNumSuspectedMembers", "The number of currently suspected members", null, org.jgroups.protocols.FD_SOCK2::getNumSuspectedMembers));
      attributes.add(new GaugeMetricInfo<>("getActualBindPort", "Actual port the server is listening on", null, org.jgroups.protocols.FD_SOCK2::getActualBindPort));
      PROTOCOL_METADATA.put(org.jgroups.protocols.FD_SOCK2.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("avgBatchSize", "Average number of messages in an BatchMessage", null, org.jgroups.protocols.BATCH::avgBatchSize));
      PROTOCOL_METADATA.put(org.jgroups.protocols.BATCH.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("avgBatchSize", "Average number of messages in an BatchMessage", null, org.jgroups.protocols.BATCH2::avgBatchSize));
      PROTOCOL_METADATA.put(org.jgroups.protocols.BATCH2.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getForkStacks", "Number of fork-stacks", null, org.jgroups.protocols.FORK::getForkStacks));
      PROTOCOL_METADATA.put(org.jgroups.protocols.FORK.class, attributes);
      attributes = new ArrayList<>();
      attributes.add(new GaugeMetricInfo<>("getDroppedMessages", "The number of dropped messages", null, org.jgroups.protocols.RED::getDroppedMessages));
      attributes.add(new GaugeMetricInfo<>("getTotalMessages", "Total number of messages processed", null, org.jgroups.protocols.RED::getTotalMessages));
      attributes.add(new GaugeMetricInfo<>("getDropRate", "Percentage of all messages that were dropped", null, org.jgroups.protocols.RED::getDropRate));
      PROTOCOL_METADATA.put(org.jgroups.protocols.RED.class, attributes);
   }
}

