/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox.store.filebased;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.util.CloseableUtil;
import org.jivesoftware.smack.util.FileUtils;
import org.jivesoftware.smackx.ox.store.abstr.AbstractOpenPgpTrustStore;
import org.jivesoftware.smackx.ox.store.definition.OpenPgpTrustStore;
import org.jivesoftware.smackx.ox.store.filebased.FileBasedOpenPgpStore;
import org.jivesoftware.smackx.ox.util.Util;
import org.jxmpp.jid.BareJid;
import org.pgpainless.key.OpenPgpV4Fingerprint;

public class FileBasedOpenPgpTrustStore
extends AbstractOpenPgpTrustStore {
    private static final Logger LOGGER = Logger.getLogger(FileBasedOpenPgpTrustStore.class.getName());
    private final File basePath;

    public static String TRUST_RECORD(OpenPgpV4Fingerprint fingerprint) {
        return fingerprint.toString() + ".trust";
    }

    public FileBasedOpenPgpTrustStore(File basePath) {
        this.basePath = basePath;
    }

    @Override
    protected OpenPgpTrustStore.Trust readTrust(BareJid owner, OpenPgpV4Fingerprint fingerprint) throws IOException {
        File file = this.getTrustPath(owner, fingerprint);
        BufferedReader reader = null;
        try {
            String line;
            FileInputStream inputStream = FileUtils.prepareFileInputStream((File)file);
            InputStreamReader isr = new InputStreamReader((InputStream)inputStream, Util.UTF8);
            reader = new BufferedReader(isr);
            OpenPgpTrustStore.Trust trust = null;
            int lineNr = 0;
            while ((line = reader.readLine()) != null) {
                ++lineNr;
                try {
                    trust = OpenPgpTrustStore.Trust.valueOf(line);
                    break;
                }
                catch (IllegalArgumentException e) {
                    LOGGER.log(Level.WARNING, "Skipping invalid trust record in line " + lineNr + " \"" + line + "\" of file " + file.getAbsolutePath());
                }
            }
            OpenPgpTrustStore.Trust trust2 = trust != null ? trust : OpenPgpTrustStore.Trust.undecided;
            CloseableUtil.maybeClose((Closeable)reader, (Logger)LOGGER);
            return trust2;
        }
        catch (IOException e) {
            block9: {
                if (!(e instanceof FileNotFoundException)) break block9;
                OpenPgpTrustStore.Trust trust = OpenPgpTrustStore.Trust.undecided;
                return trust;
            }
            throw e;
        }
        finally {
            CloseableUtil.maybeClose(reader, (Logger)LOGGER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeTrust(BareJid owner, OpenPgpV4Fingerprint fingerprint, OpenPgpTrustStore.Trust trust) throws IOException {
        File file = this.getTrustPath(owner, fingerprint);
        if (trust == null || trust == OpenPgpTrustStore.Trust.undecided) {
            FileUtils.maybeDeleteFileOrThrow((File)file);
        }
        FileUtils.maybeCreateFileWithParentDirectories((File)file);
        BufferedWriter writer = null;
        try {
            FileOutputStream outputStream = FileUtils.prepareFileOutputStream((File)file);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)outputStream, Util.UTF8);
            writer = new BufferedWriter(osw);
            writer.write(trust.toString());
        }
        catch (Throwable throwable) {
            CloseableUtil.maybeClose(writer, (Logger)LOGGER);
            throw throwable;
        }
        CloseableUtil.maybeClose((Closeable)writer, (Logger)LOGGER);
    }

    private File getTrustPath(BareJid owner, OpenPgpV4Fingerprint fingerprint) {
        return new File(FileBasedOpenPgpStore.getContactsPath(this.basePath, owner), FileBasedOpenPgpTrustStore.TRUST_RECORD(fingerprint));
    }
}

