/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox.store.filebased;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import java.util.logging.Logger;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.jivesoftware.smack.util.CloseableUtil;
import org.jivesoftware.smack.util.FileUtils;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smackx.ox.store.abstr.AbstractOpenPgpKeyStore;
import org.jivesoftware.smackx.ox.store.filebased.FileBasedOpenPgpMetadataStore;
import org.jivesoftware.smackx.ox.store.filebased.FileBasedOpenPgpStore;
import org.jxmpp.jid.BareJid;
import org.pgpainless.PGPainless;
import org.pgpainless.key.OpenPgpV4Fingerprint;

public class FileBasedOpenPgpKeyStore
extends AbstractOpenPgpKeyStore {
    private static final String PUB_RING = "pubring.pkr";
    private static final String SEC_RING = "secring.skr";
    private static final String FETCH_DATES = "fetchDates.list";
    private final File basePath;

    public FileBasedOpenPgpKeyStore(File basePath) {
        this.basePath = (File)Objects.requireNonNull((Object)basePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePublicKeysOf(BareJid owner, PGPPublicKeyRingCollection publicKeys) throws IOException {
        File file = this.getPublicKeyRingPath(owner);
        if (publicKeys == null) {
            FileUtils.maybeDeleteFileOrThrow((File)file);
            return;
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = FileUtils.prepareFileOutputStream((File)file);
            publicKeys.encode((OutputStream)outputStream);
        }
        finally {
            CloseableUtil.maybeClose((Closeable)outputStream, (Logger)LOGGER);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeSecretKeysOf(BareJid owner, PGPSecretKeyRingCollection secretKeys) throws IOException {
        File file = this.getSecretKeyRingPath(owner);
        if (secretKeys == null) {
            FileUtils.maybeDeleteFileOrThrow((File)file);
            return;
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = FileUtils.prepareFileOutputStream((File)file);
            secretKeys.encode((OutputStream)outputStream);
        }
        finally {
            CloseableUtil.maybeClose((Closeable)outputStream, (Logger)LOGGER);
        }
    }

    @Override
    public PGPPublicKeyRingCollection readPublicKeysOf(BareJid owner) throws IOException, PGPException {
        File file = this.getPublicKeyRingPath(owner);
        if (!file.exists()) {
            return null;
        }
        FileInputStream inputStream = FileUtils.prepareFileInputStream((File)file);
        PGPPublicKeyRingCollection collection = PGPainless.readKeyRing().publicKeyRingCollection((InputStream)inputStream);
        inputStream.close();
        return collection;
    }

    @Override
    public PGPSecretKeyRingCollection readSecretKeysOf(BareJid owner) throws IOException, PGPException {
        File file = this.getSecretKeyRingPath(owner);
        if (!file.exists()) {
            return null;
        }
        FileInputStream inputStream = FileUtils.prepareFileInputStream((File)file);
        PGPSecretKeyRingCollection collection = PGPainless.readKeyRing().secretKeyRingCollection((InputStream)inputStream);
        inputStream.close();
        return collection;
    }

    @Override
    protected Map<OpenPgpV4Fingerprint, Date> readKeyFetchDates(BareJid owner) throws IOException {
        return FileBasedOpenPgpMetadataStore.readFingerprintsAndDates(this.getFetchDatesPath(owner));
    }

    @Override
    protected void writeKeyFetchDates(BareJid owner, Map<OpenPgpV4Fingerprint, Date> dates) throws IOException {
        FileBasedOpenPgpMetadataStore.writeFingerprintsAndDates(dates, this.getFetchDatesPath(owner));
    }

    private File getPublicKeyRingPath(BareJid jid) {
        return new File(FileBasedOpenPgpStore.getContactsPath(this.basePath, jid), PUB_RING);
    }

    private File getSecretKeyRingPath(BareJid jid) {
        return new File(FileBasedOpenPgpStore.getContactsPath(this.basePath, jid), SEC_RING);
    }

    private File getFetchDatesPath(BareJid jid) {
        return new File(FileBasedOpenPgpStore.getContactsPath(this.basePath, jid), FETCH_DATES);
    }
}

