/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox.store.abstr;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.jivesoftware.smackx.ox.exception.MissingUserIdOnKeyException;
import org.jivesoftware.smackx.ox.selection_strategy.BareJidUserId;
import org.jivesoftware.smackx.ox.store.definition.OpenPgpKeyStore;
import org.jxmpp.jid.BareJid;
import org.pgpainless.PGPainless;
import org.pgpainless.key.OpenPgpV4Fingerprint;
import org.pgpainless.key.collection.PGPKeyRing;
import org.pgpainless.util.BCUtil;

public abstract class AbstractOpenPgpKeyStore
implements OpenPgpKeyStore {
    protected static final Logger LOGGER = Logger.getLogger(AbstractOpenPgpKeyStore.class.getName());
    protected Map<BareJid, PGPPublicKeyRingCollection> publicKeyRingCollections = new HashMap<BareJid, PGPPublicKeyRingCollection>();
    protected Map<BareJid, PGPSecretKeyRingCollection> secretKeyRingCollections = new HashMap<BareJid, PGPSecretKeyRingCollection>();
    protected Map<BareJid, Map<OpenPgpV4Fingerprint, Date>> keyFetchDates = new HashMap<BareJid, Map<OpenPgpV4Fingerprint, Date>>();

    protected abstract PGPPublicKeyRingCollection readPublicKeysOf(BareJid var1) throws IOException, PGPException;

    protected abstract void writePublicKeysOf(BareJid var1, PGPPublicKeyRingCollection var2) throws IOException;

    protected abstract PGPSecretKeyRingCollection readSecretKeysOf(BareJid var1) throws IOException, PGPException;

    protected abstract void writeSecretKeysOf(BareJid var1, PGPSecretKeyRingCollection var2) throws IOException;

    protected abstract Map<OpenPgpV4Fingerprint, Date> readKeyFetchDates(BareJid var1) throws IOException;

    protected abstract void writeKeyFetchDates(BareJid var1, Map<OpenPgpV4Fingerprint, Date> var2) throws IOException;

    @Override
    public Map<OpenPgpV4Fingerprint, Date> getPublicKeyFetchDates(BareJid contact) throws IOException {
        Map<OpenPgpV4Fingerprint, Date> dates = this.keyFetchDates.get(contact);
        if (dates == null) {
            dates = this.readKeyFetchDates(contact);
            this.keyFetchDates.put(contact, dates);
        }
        return dates;
    }

    @Override
    public void setPublicKeyFetchDates(BareJid contact, Map<OpenPgpV4Fingerprint, Date> dates) throws IOException {
        this.keyFetchDates.put(contact, dates);
        this.writeKeyFetchDates(contact, dates);
    }

    @Override
    public PGPPublicKeyRingCollection getPublicKeysOf(BareJid owner) throws IOException, PGPException {
        PGPPublicKeyRingCollection keys = this.publicKeyRingCollections.get(owner);
        if (keys == null && (keys = this.readPublicKeysOf(owner)) != null) {
            this.publicKeyRingCollections.put(owner, keys);
        }
        return keys;
    }

    @Override
    public PGPSecretKeyRingCollection getSecretKeysOf(BareJid owner) throws IOException, PGPException {
        PGPSecretKeyRingCollection keys = this.secretKeyRingCollections.get(owner);
        if (keys == null && (keys = this.readSecretKeysOf(owner)) != null) {
            this.secretKeyRingCollections.put(owner, keys);
        }
        return keys;
    }

    @Override
    public void importSecretKey(BareJid owner, PGPSecretKeyRing secretKeys) throws IOException, PGPException, MissingUserIdOnKeyException {
        if (!new BareJidUserId.SecRingSelectionStrategy().accept(owner, secretKeys)) {
            throw new MissingUserIdOnKeyException(owner, new OpenPgpV4Fingerprint(secretKeys));
        }
        PGPSecretKeyRing importKeys = BCUtil.removeUnassociatedKeysFromKeyRing((PGPSecretKeyRing)secretKeys, (PGPPublicKey)secretKeys.getPublicKey());
        PGPSecretKeyRingCollection secretKeyRings = this.getSecretKeysOf(owner);
        try {
            secretKeyRings = secretKeyRings != null ? PGPSecretKeyRingCollection.addSecretKeyRing((PGPSecretKeyRingCollection)secretKeyRings, (PGPSecretKeyRing)importKeys) : BCUtil.keyRingsToKeyRingCollection((PGPSecretKeyRing[])new PGPSecretKeyRing[]{importKeys});
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.INFO, "Skipping secret key ring " + Long.toHexString(importKeys.getPublicKey().getKeyID()) + " as it is already in the key ring of " + owner.toString());
        }
        this.secretKeyRingCollections.put(owner, secretKeyRings);
        this.writeSecretKeysOf(owner, secretKeyRings);
    }

    @Override
    public void importPublicKey(BareJid owner, PGPPublicKeyRing publicKeys) throws IOException, PGPException, MissingUserIdOnKeyException {
        if (!new BareJidUserId.PubRingSelectionStrategy().accept(owner, publicKeys)) {
            throw new MissingUserIdOnKeyException(owner, new OpenPgpV4Fingerprint(publicKeys));
        }
        PGPPublicKeyRing importKeys = BCUtil.removeUnassociatedKeysFromKeyRing((PGPPublicKeyRing)publicKeys, (PGPPublicKey)publicKeys.getPublicKey());
        PGPPublicKeyRingCollection publicKeyRings = this.getPublicKeysOf(owner);
        try {
            publicKeyRings = publicKeyRings != null ? PGPPublicKeyRingCollection.addPublicKeyRing((PGPPublicKeyRingCollection)publicKeyRings, (PGPPublicKeyRing)importKeys) : BCUtil.keyRingsToKeyRingCollection((PGPPublicKeyRing[])new PGPPublicKeyRing[]{importKeys});
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.INFO, "Skipping public key ring " + Long.toHexString(importKeys.getPublicKey().getKeyID()) + " as it is already in the key ring of " + owner.toString());
        }
        this.publicKeyRingCollections.put(owner, publicKeyRings);
        this.writePublicKeysOf(owner, publicKeyRings);
    }

    @Override
    public PGPPublicKeyRing getPublicKeyRing(BareJid owner, OpenPgpV4Fingerprint fingerprint) throws IOException, PGPException {
        PGPPublicKeyRingCollection publicKeyRings = this.getPublicKeysOf(owner);
        if (publicKeyRings != null) {
            return publicKeyRings.getPublicKeyRing(fingerprint.getKeyId());
        }
        return null;
    }

    @Override
    public PGPSecretKeyRing getSecretKeyRing(BareJid owner, OpenPgpV4Fingerprint fingerprint) throws IOException, PGPException {
        PGPSecretKeyRingCollection secretKeyRings = this.getSecretKeysOf(owner);
        if (secretKeyRings != null) {
            return secretKeyRings.getSecretKeyRing(fingerprint.getKeyId());
        }
        return null;
    }

    @Override
    public void deletePublicKeyRing(BareJid owner, OpenPgpV4Fingerprint fingerprint) throws IOException, PGPException {
        PGPPublicKeyRingCollection publicKeyRings = this.getPublicKeysOf(owner);
        if (publicKeyRings.contains(fingerprint.getKeyId())) {
            if (!(publicKeyRings = PGPPublicKeyRingCollection.removePublicKeyRing((PGPPublicKeyRingCollection)publicKeyRings, (PGPPublicKeyRing)publicKeyRings.getPublicKeyRing(fingerprint.getKeyId()))).iterator().hasNext()) {
                publicKeyRings = null;
            }
            this.publicKeyRingCollections.put(owner, publicKeyRings);
            this.writePublicKeysOf(owner, publicKeyRings);
        }
    }

    @Override
    public void deleteSecretKeyRing(BareJid owner, OpenPgpV4Fingerprint fingerprint) throws IOException, PGPException {
        PGPSecretKeyRingCollection secretKeyRings = this.getSecretKeysOf(owner);
        if (secretKeyRings.contains(fingerprint.getKeyId())) {
            if (!(secretKeyRings = PGPSecretKeyRingCollection.removeSecretKeyRing((PGPSecretKeyRingCollection)secretKeyRings, (PGPSecretKeyRing)secretKeyRings.getSecretKeyRing(fingerprint.getKeyId()))).iterator().hasNext()) {
                secretKeyRings = null;
            }
            this.secretKeyRingCollections.put(owner, secretKeyRings);
            this.writeSecretKeysOf(owner, secretKeyRings);
        }
    }

    @Override
    public PGPKeyRing generateKeyRing(BareJid owner) throws PGPException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException {
        return PGPainless.generateKeyRing().simpleEcKeyRing("xmpp:" + owner.toString());
    }
}

