/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox.provider;

import java.io.IOException;
import java.util.Date;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.ox.element.PublicKeysListElement;
import org.pgpainless.key.OpenPgpV4Fingerprint;

public final class PublicKeysListElementProvider
extends ExtensionElementProvider<PublicKeysListElement> {
    public static final PublicKeysListElementProvider TEST_INSTANCE = new PublicKeysListElementProvider();

    public PublicKeysListElement parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException.SmackTextParseException {
        PublicKeysListElement.Builder builder = PublicKeysListElement.builder();
        while (true) {
            XmlPullParser.TagEvent tag = parser.nextTag();
            switch (tag) {
                case START_ELEMENT: {
                    String name = parser.getName();
                    if (!"pubkey-metadata".equals(name)) break;
                    String finger = parser.getAttributeValue(null, "v4-fingerprint");
                    String dt = parser.getAttributeValue(null, "date");
                    OpenPgpV4Fingerprint fingerprint = new OpenPgpV4Fingerprint(finger);
                    Date date = ParserUtils.getDateFromXep82String((String)dt);
                    builder.addMetadata(new PublicKeysListElement.PubkeyMetadataElement(fingerprint, date));
                    break;
                }
                case END_ELEMENT: {
                    String name = parser.getName();
                    if (!name.equals("public-keys-list")) break;
                    return builder.build();
                }
            }
        }
    }
}

