/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox.element;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.pgpainless.key.OpenPgpV4Fingerprint;

public final class PublicKeysListElement
implements ExtensionElement {
    public static final String NAMESPACE = "urn:xmpp:openpgp:0";
    public static final String ELEMENT = "public-keys-list";
    private final Map<OpenPgpV4Fingerprint, PubkeyMetadataElement> metadata;

    private PublicKeysListElement(TreeMap<OpenPgpV4Fingerprint, PubkeyMetadataElement> metadata) {
        this.metadata = Collections.unmodifiableMap((Map)Objects.requireNonNull(metadata));
    }

    public static Builder builder() {
        return new Builder();
    }

    public TreeMap<OpenPgpV4Fingerprint, PubkeyMetadataElement> getMetadata() {
        return new TreeMap<OpenPgpV4Fingerprint, PubkeyMetadataElement>(this.metadata);
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getElementName() {
        return ELEMENT;
    }

    public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
        XmlStringBuilder xml = new XmlStringBuilder((ExtensionElement)this).rightAngleBracket();
        xml.append(this.metadata.values());
        xml.closeElement((NamedElement)this);
        return xml;
    }

    public static class PubkeyMetadataElement
    implements ExtensionElement {
        public static final String ELEMENT = "pubkey-metadata";
        public static final String ATTR_V4_FINGERPRINT = "v4-fingerprint";
        public static final String ATTR_DATE = "date";
        private final OpenPgpV4Fingerprint v4_fingerprint;
        private final Date date;

        public PubkeyMetadataElement(OpenPgpV4Fingerprint v4_fingerprint, Date date) {
            this.v4_fingerprint = (OpenPgpV4Fingerprint)Objects.requireNonNull((Object)v4_fingerprint);
            this.date = (Date)Objects.requireNonNull((Object)date);
            if (v4_fingerprint.length() != 40) {
                throw new IllegalArgumentException("OpenPGP v4 fingerprint must be 40 characters long.");
            }
        }

        public OpenPgpV4Fingerprint getV4Fingerprint() {
            return this.v4_fingerprint;
        }

        public Date getDate() {
            return this.date;
        }

        public String getElementName() {
            return ELEMENT;
        }

        public String getNamespace() {
            return PublicKeysListElement.NAMESPACE;
        }

        public XmlStringBuilder toXML(XmlEnvironment enclosingNamespace) {
            XmlStringBuilder xml = new XmlStringBuilder((ExtensionElement)this).attribute(ATTR_V4_FINGERPRINT, (CharSequence)this.getV4Fingerprint()).attribute(ATTR_DATE, this.date).closeEmptyElement();
            return xml;
        }

        public int hashCode() {
            return this.getV4Fingerprint().hashCode() + 3 * this.getDate().hashCode();
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof PubkeyMetadataElement)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            PubkeyMetadataElement otherPubkeyMetadataElement = (PubkeyMetadataElement)o;
            return this.getV4Fingerprint().equals((Object)otherPubkeyMetadataElement.getV4Fingerprint()) && this.getDate().equals(otherPubkeyMetadataElement.getDate());
        }
    }

    public static final class Builder {
        private final TreeMap<OpenPgpV4Fingerprint, PubkeyMetadataElement> metadata = new TreeMap();

        private Builder() {
        }

        public Builder addMetadata(PubkeyMetadataElement key) {
            Objects.requireNonNull((Object)key);
            this.metadata.put(key.getV4Fingerprint(), key);
            return this;
        }

        public PublicKeysListElement build() {
            return new PublicKeysListElement(this.metadata);
        }
    }
}

