/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.ox;

import java.io.IOException;
import java.nio.charset.Charset;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.ox.element.CryptElement;
import org.jivesoftware.smackx.ox.element.OpenPgpContentElement;
import org.jivesoftware.smackx.ox.element.SignElement;
import org.jivesoftware.smackx.ox.element.SigncryptElement;
import org.jivesoftware.smackx.ox.provider.OpenPgpContentElementProvider;
import org.pgpainless.decryption_verification.OpenPgpMetadata;

public class OpenPgpMessage {
    private final String element;
    private final State state;
    private final OpenPgpMetadata metadata;
    private OpenPgpContentElement openPgpContentElement;

    public OpenPgpMessage(String content, State state, OpenPgpMetadata metadata) {
        this.metadata = (OpenPgpMetadata)Objects.requireNonNull((Object)metadata);
        this.state = (State)((Object)Objects.requireNonNull((Object)((Object)state)));
        this.element = (String)Objects.requireNonNull((Object)content);
    }

    public OpenPgpMessage(byte[] bytes, State state, OpenPgpMetadata metadata) {
        this(new String((byte[])Objects.requireNonNull((Object)bytes), Charset.forName("UTF-8")), state, metadata);
    }

    public OpenPgpContentElement getOpenPgpContentElement() throws XmlPullParserException, IOException {
        this.ensureOpenPgpContentElementSet();
        return this.openPgpContentElement;
    }

    private void ensureOpenPgpContentElementSet() throws XmlPullParserException, IOException {
        if (this.openPgpContentElement != null) {
            return;
        }
        this.openPgpContentElement = OpenPgpContentElementProvider.parseOpenPgpContentElement(this.element);
        if (this.openPgpContentElement == null) {
            return;
        }
        if (this.openPgpContentElement instanceof SigncryptElement) {
            if (this.state != State.signcrypt) {
                throw new IllegalStateException("OpenPgpContentElement was signed and encrypted, but is not a SigncryptElement.");
            }
        } else if (this.openPgpContentElement instanceof SignElement) {
            if (this.state != State.sign) {
                throw new IllegalStateException("OpenPgpContentElement was signed and unencrypted, but is not a SignElement.");
            }
        } else if (this.openPgpContentElement instanceof CryptElement && this.state != State.crypt) {
            throw new IllegalStateException("OpenPgpContentElement was unsigned and encrypted, but is not a CryptElement.");
        }
    }

    public State getState() throws IOException, XmlPullParserException {
        this.ensureOpenPgpContentElementSet();
        return this.state;
    }

    public OpenPgpMetadata getMetadata() {
        return this.metadata;
    }

    public static enum State {
        signcrypt,
        sign,
        crypt;

    }
}

