/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.iot.data.provider;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.iot.data.element.IoTDataField;
import org.jivesoftware.smackx.iot.data.element.IoTFieldsExtension;
import org.jivesoftware.smackx.iot.data.element.NodeElement;
import org.jivesoftware.smackx.iot.data.element.TimestampElement;
import org.jivesoftware.smackx.iot.element.NodeInfo;
import org.jivesoftware.smackx.iot.parser.NodeInfoParser;
import org.jxmpp.util.XmppDateTime;

public class IoTFieldsExtensionProvider
extends ExtensionElementProvider<IoTFieldsExtension> {
    private static final Logger LOGGER = Logger.getLogger(IoTFieldsExtensionProvider.class.getName());

    /*
     * Enabled aggressive block sorting
     */
    public IoTFieldsExtension parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws IOException, XmlPullParserException, SmackParsingException.SmackTextParseException {
        int seqNr = ParserUtils.getIntegerAttributeOrThrow((XmlPullParser)parser, (String)"seqnr", (String)"IoT data request <accepted/> without sequence number");
        boolean done = ParserUtils.getBooleanAttribute((XmlPullParser)parser, (String)"done", (boolean)false);
        ArrayList<NodeElement> nodes = new ArrayList<NodeElement>();
        while (true) {
            XmlPullParser.Event eventType = parser.next();
            String name = parser.getName();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    switch (name) {
                        case "node": {
                            NodeElement node = this.parseNode(parser);
                            nodes.add(node);
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return new IoTFieldsExtension(seqNr, done, nodes);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public NodeElement parseNode(XmlPullParser parser) throws XmlPullParserException, IOException, SmackParsingException.SmackTextParseException {
        int initialDepth = parser.getDepth();
        NodeInfo nodeInfo = NodeInfoParser.parse(parser);
        ArrayList<TimestampElement> timestampElements = new ArrayList<TimestampElement>();
        while (true) {
            XmlPullParser.Event eventType = parser.next();
            String name = parser.getName();
            block0 : switch (eventType) {
                case START_ELEMENT: {
                    switch (name) {
                        case "timestamp": {
                            TimestampElement timestampElement = this.parseTimestampElement(parser);
                            timestampElements.add(timestampElement);
                            break block0;
                        }
                    }
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return new NodeElement(nodeInfo, timestampElements);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TimestampElement parseTimestampElement(XmlPullParser parser) throws XmlPullParserException, IOException, SmackParsingException.SmackTextParseException {
        Date date;
        int initialDepth = parser.getDepth();
        String dateString = parser.getAttributeValue(null, "value");
        try {
            date = XmppDateTime.parseDate((String)dateString);
        }
        catch (ParseException e) {
            throw new SmackParsingException.SmackTextParseException(e);
        }
        ArrayList<void> fields = new ArrayList<void>();
        while (true) {
            XmlPullParser.Event eventType = parser.next();
            switch (eventType) {
                case START_ELEMENT: {
                    void var8_9;
                    String name = parser.getName();
                    Object var8_10 = null;
                    String fieldName = parser.getAttributeValue(null, "name");
                    String fieldValue = parser.getAttributeValue(null, "value");
                    switch (name) {
                        case "int": {
                            boolean bl = Integer.parseInt(fieldValue);
                            IoTDataField.IntField intField = new IoTDataField.IntField(fieldName, bl ? 1 : 0);
                            break;
                        }
                        case "boolean": {
                            boolean bl = Boolean.parseBoolean(fieldValue);
                            IoTDataField.BooleanField booleanField = new IoTDataField.BooleanField(fieldName, bl);
                            break;
                        }
                        default: {
                            LOGGER.warning("IoT Data field type '" + name + "' not implement yet. Ignoring.");
                        }
                    }
                    if (var8_9 == null) break;
                    fields.add(var8_9);
                    break;
                }
                case END_ELEMENT: {
                    if (parser.getDepth() != initialDepth) break;
                    return new TimestampElement(date, fields);
                }
            }
        }
    }
}

