/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.dox;

import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smack.util.RandomUtil;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.dox.DnsOverXmppResolver;
import org.jivesoftware.smackx.dox.element.DnsIq;
import org.jxmpp.jid.Jid;
import org.minidns.dnsmessage.DnsMessage;
import org.minidns.dnsmessage.Question;

public final class DnsOverXmppManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(DnsOverXmppManager.class.getName());
    private static final Map<XMPPConnection, DnsOverXmppManager> INSTANCES = new WeakHashMap<XMPPConnection, DnsOverXmppManager>();
    private static final String NAMESPACE = "urn:xmpp:dox:0";
    private static DnsOverXmppResolver defaultResolver;
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private DnsOverXmppResolver resolver = defaultResolver;
    private boolean enabled;
    private final AbstractIqRequestHandler dnsIqRequestHandler = new AbstractIqRequestHandler("dns", "urn:xmpp:dox:0", IQ.Type.get, IQRequestHandler.Mode.async){

        public IQ handleIQRequest(IQ iqRequest) {
            DnsMessage response;
            DnsOverXmppResolver resolver = DnsOverXmppManager.this.resolver;
            if (resolver == null) {
                LOGGER.info("Resolver was null while attempting to handle " + iqRequest);
                return null;
            }
            DnsIq dnsIqRequest = (DnsIq)iqRequest;
            DnsMessage query = dnsIqRequest.getDnsMessage();
            try {
                response = resolver.resolve(query);
            }
            catch (IOException exception) {
                StanzaError errorBuilder = ((StanzaError.Builder)StanzaError.getBuilder().setType(StanzaError.Type.CANCEL).setCondition(StanzaError.Condition.internal_server_error).setDescriptiveEnText("Exception while resolving your DNS query", (Exception)exception)).build();
                ErrorIQ errorResponse = IQ.createErrorResponse((IQ)iqRequest, (StanzaError)errorBuilder);
                return errorResponse;
            }
            if (query.id != response.id) {
                response = response.asBuilder().setId(query.id).build();
            }
            DnsIq dnsIqResult = new DnsIq(response);
            dnsIqResult.setType(IQ.Type.result);
            return dnsIqResult;
        }
    };

    public static synchronized DnsOverXmppManager getInstanceFor(XMPPConnection connection) {
        DnsOverXmppManager manager = INSTANCES.get(connection);
        if (manager == null) {
            manager = new DnsOverXmppManager(connection);
            INSTANCES.put(connection, manager);
        }
        return manager;
    }

    public static void setDefaultDnsOverXmppResolver(DnsOverXmppResolver resolver) {
        defaultResolver = resolver;
    }

    private DnsOverXmppManager(XMPPConnection connection) {
        super(connection);
        this.serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection);
    }

    public synchronized void setDnsOverXmppResolver(DnsOverXmppResolver resolver) {
        this.resolver = resolver;
        if (resolver == null) {
            this.disable();
        }
    }

    public synchronized void enable() {
        if (this.enabled) {
            return;
        }
        if (this.resolver == null) {
            throw new IllegalStateException("No DnsOverXmppResolver configured");
        }
        XMPPConnection connection = this.connection();
        if (connection == null) {
            return;
        }
        connection.registerIQRequestHandler((IQRequestHandler)this.dnsIqRequestHandler);
        this.serviceDiscoveryManager.addFeature(NAMESPACE);
    }

    public synchronized void disable() {
        if (!this.enabled) {
            return;
        }
        XMPPConnection connection = this.connection();
        if (connection == null) {
            return;
        }
        this.serviceDiscoveryManager.removeFeature(NAMESPACE);
        connection.unregisterIQRequestHandler((IQRequestHandler)this.dnsIqRequestHandler);
    }

    public boolean isSupported(Jid jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return this.serviceDiscoveryManager.supportsFeature(jid, (CharSequence)NAMESPACE);
    }

    public DnsMessage query(Jid jid, Question question) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DnsMessage queryMessage = DnsMessage.builder().addQuestion(question).setId(RandomUtil.nextSecureRandomInt()).setRecursionDesired(true).build();
        return this.query(jid, queryMessage);
    }

    public DnsMessage query(Jid jid, DnsMessage query) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        DnsIq queryIq = new DnsIq(query, jid);
        DnsIq responseIq = (DnsIq)this.connection().sendIqRequestAndWaitForResponse((IQ)queryIq);
        return responseIq.getDnsMessage();
    }
}

