/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.chat_markers;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jivesoftware.smack.AsyncButOrdered;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.chat2.Chat;
import org.jivesoftware.smack.chat2.ChatManager;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.MessageWithBodiesFilter;
import org.jivesoftware.smack.filter.NotFilter;
import org.jivesoftware.smack.filter.PossibleFromTypeFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.chat_markers.ChatMarkersListener;
import org.jivesoftware.smackx.chat_markers.ChatMarkersState;
import org.jivesoftware.smackx.chat_markers.element.ChatMarkersElements;
import org.jivesoftware.smackx.chat_markers.filter.ChatMarkersFilter;
import org.jivesoftware.smackx.chat_markers.filter.EligibleForChatMarkerFilter;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jxmpp.jid.EntityBareJid;

public final class ChatMarkersManager
extends Manager {
    private static final Map<XMPPConnection, ChatMarkersManager> INSTANCES;
    private static final StanzaFilter INCOMING_MESSAGE_FILTER;
    private static final StanzaFilter OUTGOING_MESSAGE_FILTER;
    private final Set<ChatMarkersListener> incomingListeners = new HashSet<ChatMarkersListener>();
    private final AsyncButOrdered<Chat> asyncButOrdered = new AsyncButOrdered();
    private final ChatManager chatManager;
    private final ServiceDiscoveryManager serviceDiscoveryManager;
    private boolean enabled;

    public static synchronized ChatMarkersManager getInstanceFor(XMPPConnection connection) {
        ChatMarkersManager chatMarkersManager = INSTANCES.get(connection);
        if (chatMarkersManager == null) {
            chatMarkersManager = new ChatMarkersManager(connection);
            INSTANCES.put(connection, chatMarkersManager);
        }
        return chatMarkersManager;
    }

    private ChatMarkersManager(XMPPConnection connection) {
        super(connection);
        this.chatManager = ChatManager.getInstanceFor((XMPPConnection)connection);
        connection.addMessageInterceptor(mb -> mb.addExtension((ExtensionElement)ChatMarkersElements.MarkableExtension.INSTANCE), m -> OUTGOING_MESSAGE_FILTER.accept((Stanza)m));
        connection.addSyncStanzaListener(new StanzaListener(){

            public void processStanza(Stanza packet) throws SmackException.NotConnectedException, InterruptedException, SmackException.NotLoggedInException {
                final Message message = (Message)packet;
                EntityBareJid bareFrom = message.getFrom().asEntityBareJidOrThrow();
                final Chat chat = ChatMarkersManager.this.chatManager.chatWith(bareFrom);
                ChatMarkersManager.this.asyncButOrdered.performAsyncButOrdered((Object)chat, new Runnable(){

                    @Override
                    public void run() {
                        for (ChatMarkersListener listener : ChatMarkersManager.this.incomingListeners) {
                            if (ChatMarkersElements.MarkableExtension.from(message) != null) {
                                listener.newChatMarkerMessage(ChatMarkersState.markable, message, chat);
                                continue;
                            }
                            if (ChatMarkersElements.ReceivedExtension.from(message) != null) {
                                listener.newChatMarkerMessage(ChatMarkersState.received, message, chat);
                                continue;
                            }
                            if (ChatMarkersElements.DisplayedExtension.from(message) != null) {
                                listener.newChatMarkerMessage(ChatMarkersState.displayed, message, chat);
                                continue;
                            }
                            if (ChatMarkersElements.AcknowledgedExtension.from(message) == null) continue;
                            listener.newChatMarkerMessage(ChatMarkersState.acknowledged, message, chat);
                        }
                    }
                });
            }
        }, INCOMING_MESSAGE_FILTER);
        this.serviceDiscoveryManager = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection);
    }

    @Deprecated
    public boolean isSupportedByServer() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException, InterruptedException {
        return ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.connection()).serverSupportsFeature((CharSequence)"urn:xmpp:chat-markers:0");
    }

    public synchronized boolean addIncomingChatMarkerMessageListener(ChatMarkersListener listener) {
        boolean res = this.incomingListeners.add(listener);
        if (!this.enabled) {
            this.serviceDiscoveryManager.addFeature("urn:xmpp:chat-markers:0");
            this.enabled = true;
        }
        return res;
    }

    public synchronized boolean removeIncomingChatMarkerMessageListener(ChatMarkersListener listener) {
        boolean res = this.incomingListeners.remove(listener);
        if (this.incomingListeners.isEmpty() && this.enabled) {
            this.serviceDiscoveryManager.removeFeature("urn:xmpp:chat-markers:0");
            this.enabled = false;
        }
        return res;
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                ChatMarkersManager.getInstanceFor(connection);
            }
        });
        INSTANCES = new WeakHashMap<XMPPConnection, ChatMarkersManager>();
        INCOMING_MESSAGE_FILTER = new AndFilter(new StanzaFilter[]{MessageTypeFilter.NORMAL_OR_CHAT, new StanzaExtensionFilter("urn:xmpp:chat-markers:0"), PossibleFromTypeFilter.ENTITY_BARE_JID, EligibleForChatMarkerFilter.INSTANCE});
        OUTGOING_MESSAGE_FILTER = new AndFilter(new StanzaFilter[]{MessageTypeFilter.NORMAL_OR_CHAT, MessageWithBodiesFilter.INSTANCE, new NotFilter(ChatMarkersFilter.INSTANCE), EligibleForChatMarkerFilter.INSTANCE});
    }
}

