/*
 * SPDX-License-Identifier: Apache-2.0
 * Copyright Red Hat Inc. and Hibernate Authors
 */
package org.hibernate.validator.internal.constraintvalidators.bv.money;

import javax.money.MonetaryAmount;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraints.NegativeOrZero;

/**
 * Check that the number being validated positive.
 *
 * @author Marko Bekhta
 */
public class NegativeOrZeroValidatorForMonetaryAmount implements ConstraintValidator<NegativeOrZero, MonetaryAmount> {

	@Override
	public boolean isValid(MonetaryAmount value, ConstraintValidatorContext context) {
		// null values are valid
		if ( value == null ) {
			return true;
		}

		return value.signum() <= 0;
	}
}
