/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.arrow.vector;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.arrow.ArrowArray;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;

@ExportLibrary(value=InteropLibrary.class)
public class VectorArrowArrayReleaseCallback
implements TruffleObject {
    @ExportMessage
    boolean isExecutable() {
        return true;
    }

    @ExportMessage
    static class Execute {
        Execute() {
        }

        @Specialization(guards={"validateArgs(args)"})
        static Object doRelease(VectorArrowArrayReleaseCallback self, Object[] args, @Bind(value="$node") Node inliningTarget, @Cached PRaiseNode.Lazy raiseNode) {
            ArrowArray arrowArray = ArrowArray.wrap((Long)args[0]);
            if (arrowArray.isReleased()) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.ARROW_ARRAY_ALREADY_RELEASED);
            }
            arrowArray.markReleased();
            return PNone.NO_VALUE;
        }

        @Fallback
        static Object doError(VectorArrowArrayReleaseCallback self, Object[] args) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        static boolean validateArgs(Object[] args) {
            return args.length == 1 && args[0] instanceof Long;
        }
    }
}

